/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEIMAGEFEATURETEXTURECOMPUTER_HPP
#define ISEIMAGEFEATURETEXTURECOMPUTER_HPP

#include <girl/girlCommon.hpp>

#include "iseImageFeatureComputer.hpp"
#include "iseSegmentationContext.hpp"


namespace ise {

  class GIRL_API ImageFeatureTextureComputer : public ImageFeatureComputer
  {
  public:
    
    explicit ImageFeatureTextureComputer(ise::SegmentationContext *segC)
      : ImageFeatureComputer(segC, "Texture")
      {
      }
    
    virtual ~ImageFeatureTextureComputer()
    {
    }

  private:
    ImageFeatureTextureComputer(const ImageFeatureTextureComputer&);
    ImageFeatureTextureComputer &operator=(const ImageFeatureTextureComputer&);
    
  };
}
#endif /* ! ISEIMAGEFEATURETEXTURECOMPUTER_HPP */
