/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef IMAGEFEATURECOMPUTERDEFAULT_HPP
#define IMAGEFEATURECOMPUTERDEFAULT_HPP

#include "iseImageFeatureComputer.hpp"
//#include "iseURI.hpp"

namespace ise {
  
  class GIRL_API ImageFeatureComputerDefault : public ImageFeatureComputer
  {

    static const size_t FEATURE_DIMENSION = 3;

  public:

    static const char* DEFAULT_IMAGE_FEATURE;// = __FILE__;

  public:
    explicit ImageFeatureComputerDefault(ise::SegmentationContext *segC)
      : ImageFeatureComputer(segC, "Colorimetric")
      {
	//	setTitle(DEFAULT_IMAGE_FEATURE);
      }

    virtual ~ImageFeatureComputerDefault()
    {
    }

    virtual void compute();

    virtual const std::string uri() const;

    virtual const std::string baseUri() const;

    void
    getDimDescription(std::vector<std::string> &dimDesc) const;

    size_t
    getFeatureDim() const;

    void
    getRequiredComputers(FeatureComputerListType &) const {}




  private:
    
    ImageFeatureComputerDefault(const ImageFeatureComputerDefault&);
    ImageFeatureComputerDefault &operator=(const ImageFeatureComputerDefault&);
  };
}

#endif /* !  IMAGEFEATURECOMPUTERDEFAULT_HPP */
