/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "iseImageFeatureComputerDefault.hpp"
#include "iseSegmentationContext.hpp"

using namespace ise;

const char* ImageFeatureComputerDefault::DEFAULT_IMAGE_FEATURE = "Loaded_image";//__FILE__;

const std::string
ImageFeatureComputerDefault::baseUri() const
{
  return DEFAULT_IMAGE_FEATURE;
}

const std::string
ImageFeatureComputerDefault::uri() const
{
  return baseUri();
}

void 
ImageFeatureComputerDefault::compute()
{
  assert(m_segContext);
  assert(m_segContext->getImage());

  girl::tools::Image *img = m_segContext->getImage();
  
  const int width = img->width(); 
  const int height = img->height();
  const int channels = img->channels();

  m_imgF = girl::shared_ptr<girl::tools::ImageFeature>(new girl::tools::ImageFeature(width, height, FEATURE_DIMENSION/*channels*/)); // TODO

  for ( int j = 0 ; j < height ; ++j) {

    girl::tools::Image::type *imgBuf = img->scanLine(j);
    girl::tools::ImageFeature::type *imgfBuf = m_imgF->scanLine(j);

    for (int i = 0 ; i < width ; ++i) {
      for (int c = 0; c < channels ; ++c) {
	imgfBuf[c] = imgBuf[c];
      }
      imgBuf += img->formatSize();
      imgfBuf += m_imgF->formatSize();
    }

  }
}

void
ImageFeatureComputerDefault::getDimDescription(std::vector<std::string> &dimDesc) const
{
  dimDesc.clear();
  for (int i = 0 ; i < m_imgF->channels() ; ++i)
    dimDesc.push_back("LoadedImage");
}

size_t
ImageFeatureComputerDefault::getFeatureDim() const
{
  return FEATURE_DIMENSION;
}


