/*
  Copyright (C) 2005-2011 Julian Roigt, Remi Vieux, Boris Mansencal, boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEIMAGEFEATURECOMPUTER_HPP
#define ISEIMAGEFEATURECOMPUTER_HPP

#include <girlTools/girlToolsImageFeature.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseFeatureComputer.hpp"
namespace ise{

  class SegmentationContext;

  class GIRL_API ImageFeatureComputer : public FeatureComputer
  {
  public:
    /**
     * Use this separator in COMPUTER URI function to isolate the different parts of 
     * the COMPUTER URI such as the parameters
     */
    static const char IMAGE_FEATURE_URI_SEPARATOR = '#';

  public:

    ImageFeatureComputer(ise::SegmentationContext *segContext, const std::string &computerUri = "", girl::shared_ptr<girl::tools::ImageFeature> imgF = girl::shared_ptr<girl::tools::ImageFeature>())
    : FeatureComputer(segContext),
      m_imgF(imgF),
      m_computerUri(computerUri)
      {}
    
    virtual ~ImageFeatureComputer() {}

    /**
     * R:TODO Reset function let empty for ImageFeatureComputer, because
     * shall we really reset the image feature? Maybe this function does
     * not belong in FeatureComputer interface
     */
    void
    reset() {}

    bool
    isTogerObserver() const { return false; }


    virtual void
    setCacheState(FeatureComputer::CacheType) {}

    // R: in FeatureComputer
//    virtual void compute() = 0;

    /**
      * Do nothing because image feature do not change once computed
      */
    void
    update() {}
    
    /**
     * @brief Get the image feature uri
     */
    virtual const std::string uri() const = 0;

    /**
     * @brief Get the first word of image feature uri 
     */
    virtual const std::string baseUri() const = 0;


    // R: In FeatureComputer (function getDescription)
//    inline void featureDesciption(std::string &title, std::vector<std::string> &dimDesc) const
//    {
//      featureTitle(title);
//      featureDimDescription(dimDesc);
//    }

    /**
     * @brief title is filled with name of the feature
     */
    // R: in FeatureComputer (getTitle())
  //  std::string title() const { return m_title; }

  //  void featureTitle(std::string &title) const { title = m_title; }

    // R: in FeatureComputer (setTitle(string))
    //void setFeatureTitle(const std::string &title) { m_title = title; }

    /**
     * @brief return a sementic description of each dimension of the feature vector
     */
    // R: in FeatureComputer (getDimDescription)
  //  virtual void featureDimDescription(std::vector<std::string> &dimDesc) const = 0;
    
    /**
     * @brief Get the dimension of image feature
     */
    // R: in FeatureComputer getFeatureDim()
//    inline int dim() const {
//      if (m_imgF != NULL)
//    	return m_imgF->channels();
//
//      return featureDim();
//    }
//
//    virtual int featureDim() const = 0;

    /**
     * @brief Get the image feature computer type uri (Colorimetric, Geometric, ...)
     */
    const std::string imageFeatureComputerUri() const { return m_computerUri; }

    /**
     * @brief Add an image feature computer type uri 
     *        ex:Binary is a subtype of Colorimetric
     * @param computerUri : the uri to add
     */
    void addImageFeatureComputerUri(const std::string &computerUri) { 
      std::stringstream ss;
      ss << m_computerUri << IMAGE_FEATURE_URI_SEPARATOR << computerUri;
      m_computerUri = ss.str();
    }

    /**
     * @brief Get the const image feature
     */
    const girl::shared_ptr<girl::tools::ImageFeature> getImageFeature() const { return m_imgF; }
    
    /**
     * @brief Get the image feature
     */
    girl::shared_ptr<girl::tools::ImageFeature> getImageFeature() {return m_imgF; }

    /**
     * @brief Set the segmentation context
     */
 //   inline void setSegContext(ise::SegmentationContext *segC) { m_segContext = segC; }
    
//    void setChannelsName(const std::vector<std::string> &channelsName)
//    {
//      m_channelsName = channelsName;
//    }

    /**
     * @brief get channel name at index @a index
     */ 
//    std::string channelName(int index)
//    {
//      assert(index <= static_cast<int>(m_channelsName.size()));
//      return m_channelsName[index];
//    }

    void
    setImageFeature(girl::shared_ptr<girl::tools::ImageFeature> &imf)
    {
      assert (static_cast<size_t>(imf->channels()) == getFeatureDim());
      m_imgF = imf;
    }

  protected:

   // ise::SegmentationContext *m_segContext;

    girl::shared_ptr<girl::tools::ImageFeature> m_imgF;
    
    std::string m_computerUri;

  //  std::vector<std::string> m_channelsName;
    
   // std::string m_title;
  };

  typedef girl::shared_ptr<ise::ImageFeatureComputer> ImageFeatureComputerPtr;

}


#endif /* ! ISEIMAGEFEATURECOMPUTER_HPP */
