/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEIMAGEFEATURECOMPOSITIONCOMPUTER_HPP
#define ISEIMAGEFEATURECOMPOSITIONCOMPUTER_HPP

#include <girl/girlCommon.hpp>

#include "iseImageFeatureComputer.hpp"
#include "iseSegmentationContext.hpp"


namespace ise {

  class GIRL_API ImageFeatureCompositionComputer : public ImageFeatureComputer
  {
  public:
    explicit ImageFeatureCompositionComputer(ise::SegmentationContext *segC)
      : ImageFeatureComputer(segC, "Composition")
      {
      }
    
    virtual ~ImageFeatureCompositionComputer()
    {
    }

    // bool containTitle(const std::string &title)
    // {
    //   size_t size = m_titles.size();
      
    //   for (size_t i = 0 ; i < size ; ++i) {
    // 	if (m_titles[i] == title)
    // 	  return true;
    //   }
    //   return false;
    // }

  private:
    ImageFeatureCompositionComputer(const ImageFeatureCompositionComputer&);
    ImageFeatureCompositionComputer &operator=(const ImageFeatureCompositionComputer&);
    
  protected:
    //std::vector<std::string> m_titles;
    std::vector<girl::shared_ptr<ImageFeatureComputer> > m_algos;

  };
}
#endif /* ! ISEIMAGEFEATUREOTHERCOMPUTER_HPP */
