/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEIMAGEFEATURECOLORSPACE_HPP
#define ISEIMAGEFEATURECOLORSPACE_HPP

#include <vector>

#include <girl/girlCommon.hpp>
#include <girlTools/girlToolsImageFeature.hpp>

#include "iseFactoryTemplate.hxx"
#include "iseImageFeatureColorimetricComputer.hpp"
#include "iseSegmentationContext.hpp"


namespace ise {

  class GIRL_API ImageFeatureColorSpace : public ise::ImageFeatureColorimetricComputer
  {
    static const int FEATURE_DIMENSION = 3;

  public:
    ImageFeatureColorSpace(ise::SegmentationContext *segC, int colorSpace = 0);
    
    virtual ~ImageFeatureColorSpace()
    {
    }

    virtual void compute();
    
    void compute(const girl::tools::Image &img);

    void setParameters(int colorSpace);

    void getParameters(int &colorSpace) const;

    virtual const std::string uri() const;

    virtual const std::string baseUri() const;

    /**
     * @brief return a description of feature : "ColorSpace iseColorSpace channel"
     * ex : "ColorSpace ISE_RGB_to_LUV 1"
     */ 
    void
    getDimDescription(std::vector<std::string> &dimDesc) const;

    size_t
    getFeatureDim() const { return FEATURE_DIMENSION; }

    void
    getRequiredComputers(FeatureComputerListType&) const {}

  private:
    ImageFeatureColorSpace(const ImageFeatureColorSpace&);
    ImageFeatureColorSpace &operator=(const ImageFeatureColorSpace&);

  private:
    
    int m_colorSpace;
  };

  typedef FactoryTemplate<ImageFeatureComputer, ImageFeatureColorSpace> ImageFeatureColorSpaceFactory;

}
#endif /* ! ISEIMAGEFEATURECOLORSPACE_HPP */
