/*
  Copyright (C) 2013 Boris Mansencal, Jean-Philippe Domenger boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEIMAGEFEATURECOLORPROJECTION_HPP
#define ISEIMAGEFEATURECOLORPROJECTION_HPP

#include "iseFactoryTemplate.hxx"
#include "iseImageFeatureColorimetricComputer.hpp"

namespace ise {

  class GIRL_API ImageFeatureColorProjection : public ise::ImageFeatureColorimetricComputer
  {
    static const int FEATURE_DIMENSION = 2;

  public:

    explicit ImageFeatureColorProjection(ise::SegmentationContext *segContext);


    /**
     *
     * Warning @a colorSpace must have 3 channels and cannot be ISE_RGB_to_GRAY.
     */
    void setParameters(int colorSpace, double a00, double a01, double a02, double a10, double a11, double a12, double tx=0, double ty=0);

    void getParameters(int &colorSpace, double &a00, double &a01, double &a02, double &a10, double &a11, double &a12, double &tx, double &ty);


    virtual void compute();

    void compute(const girl::tools::Image &img);


    virtual size_t getFeatureDim() const { return FEATURE_DIMENSION; }

    virtual void getDimDescription(std::vector<std::string> &dimDesc) const;

    virtual void getRequiredComputers(FeatureComputerListType & /* computers */) const {}

    
    virtual const std::string uri() const;

    virtual const std::string baseUri() const;


  protected:
    
    void transform(int a, int b, int c, double &x, double &y);

  protected:
    double m_a00, m_a01, m_a02, m_a10, m_a11, m_a12, m_tx, m_ty;
    int m_colorSpace;
  };

  typedef FactoryTemplate<ImageFeatureComputer, ImageFeatureColorProjection> ImageFeatureColorProjectionFactory;
}

#endif /* ! ISEIMAGEFEATURECOLORPROJECTION_HPP */

