/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ISEIMAGEFEATURECOLLECTION_HPP
#define ISEIMAGEFEATURECOLLECTION_HPP

#include <list>
#include <set>

#include <girlTools/girlToolsImageFeature.hpp>
#include <girl/girlHashMap.hpp>


// TODO: REMOVE OBSOLETE
namespace ise
{
  class ImageFeatureComputer;

  class GIRL_API ImageFeatureCollection
  {
  public:
    
    ImageFeatureCollection();

    virtual ~ImageFeatureCollection();

    /**
     * Insert ImageFeatureComputer @a imgFcomputer into the collection
     */
    void add(girl::shared_ptr<ise::ImageFeatureComputer> imgFcomputer);

    /**
     * Remove imageFeature @a title from the collection
     * @a title is the identifier of a image feature, such as obtained by the function ImageFeature.title()
     */
    void remove(const std::string &title);

    /**
     * Return the image feature identified by @a title or NULL if it doesn't exists
     * Warning: the image feature is NOT removed from the collection.
     */
    const girl::shared_ptr<girl::tools::ImageFeature> getImageFeature(const std::string &title) const;

    const girl::shared_ptr<ImageFeatureComputer> getImageFeatureComputer(const std::string &title) const;

    /**
     * Clear all images features in all the registered regSets.
     */
    void reset();

    /**
     * Remove all the registered imgF. Will call reset() to make sure everything is cleaned up
     */
    void clear(); 

    /**
     * Size of collection.
     */
    size_t size();

    /**
     * @brief Get the list of image features computer type uris
     *        with her image feature computer type uri is @a imageFeatureComputerUri
     * @param list:  filled with the uris of the image features computer in the segmentation context
     * @param imageFeatureComputerTypeUri: the image feature computer type uri 
     */
    void getTitles(std::list<std::string> &list, const std::string &imageFeatureComputerTypeUri = "") const;

    /**
     * @brief Get the list of images features uris 
     *        with her base image feature uri
     *        is @a imageFeatureComputerUri
     * @param list: filled with the uris of the image features computer
     * @param imageFeatureComputerTypeUri: the image feature computer base uri
     */
    void getTitlesBaseURIs(std::list<std::string> &list, const std::string &imageFeatureComputerTypeUri = "") const;

    /**
     * @param title the identifier of an image feature computer
     * Return true if this image feature computer exists in the collection, false otherwise
     */
    inline bool exists(const std::string &title) { return m_imageFeaturesComputer.find(title) != m_imageFeaturesComputer.end(); }

    /**
     * @brief Get the list of computer uri
     */
    void computersUri(std::set<std::string> &uris) const;

  protected:

    typedef girl::hashMap<std::string, girl::shared_ptr<ise::ImageFeatureComputer> > ContainerType;

    ContainerType m_imageFeaturesComputer;
  };
}

#endif /* ! ISEIMAGEFEATURECOLLECTION_HPP */
