/*
  Segmentation context: toger, image, region features, ...
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "iseImageFeatureCollection.hpp"
#include "iseImageFeatureComputer.hpp"
#include <iostream> //debug

namespace ise
{
  ImageFeatureCollection::ImageFeatureCollection()
    : m_imageFeaturesComputer()
  {
  }

  ImageFeatureCollection::~ImageFeatureCollection()
  {
  }

  void
  ImageFeatureCollection::add(girl::shared_ptr<ise::ImageFeatureComputer> /*imgFcomputer*/)
  {
   // m_imageFeaturesComputer[imgFcomputer->getTitle()] = imgFcomputer;
  }

  void
  ImageFeatureCollection::remove(const std::string &title)
  {
    m_imageFeaturesComputer.erase(title);
  }

  const girl::shared_ptr<girl::tools::ImageFeature>
  ImageFeatureCollection::getImageFeature(const std::string &title) const
  {
    ContainerType::const_iterator it = m_imageFeaturesComputer.find(title);
    if (it != m_imageFeaturesComputer.end())
      return (*it).second->getImageFeature();
    return girl::shared_ptr<girl::tools::ImageFeature>();
  }

  const girl::shared_ptr<ImageFeatureComputer>
  ImageFeatureCollection::getImageFeatureComputer(const std::string &title) const
  {
    ContainerType::const_iterator it = m_imageFeaturesComputer.find(title);
    if (it != m_imageFeaturesComputer.end()) {
      return it->second;
    }
    return girl::shared_ptr<ise::ImageFeatureComputer>();
  }

  void
  ImageFeatureCollection::reset()
  {
    ContainerType::iterator it = m_imageFeaturesComputer.begin();
    const ContainerType::iterator itEnd = m_imageFeaturesComputer.end();
    for ( ; it != itEnd ; ++it)
      (*it).second->getImageFeature()->release();
  }

  void
  ImageFeatureCollection::clear()
  {
    reset();
    m_imageFeaturesComputer.clear();
  }

  size_t
  ImageFeatureCollection::size()
  {
    return m_imageFeaturesComputer.size();
  }

  void
  ImageFeatureCollection::getTitles(std::list<std::string> &list, const std::string &imageFeatureComputerTypeUri) const 
  {
    ContainerType::const_iterator it = m_imageFeaturesComputer.begin();
    const ContainerType::const_iterator itEnd = m_imageFeaturesComputer.end();
    for ( ; it != itEnd ; ++it) {
      if (imageFeatureComputerTypeUri.empty()) {
	list.push_back((*it).first);
      }
      else {
	const std::string uri = (*it).second->imageFeatureComputerUri();
	std::vector<std::string> computerUris;
	size_t  firstPos = 0;
	size_t pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
	while ( pos <= uri.length() ) {
	  computerUris.push_back(uri.substr(firstPos, pos - firstPos));
	  firstPos = pos+1;
	  pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
	}
	computerUris.push_back(uri.substr(firstPos, uri.length()));
	for (size_t i = 0 ; i < computerUris.size() ; ++i) {
	  if (imageFeatureComputerTypeUri == computerUris[i]) {
	    list.push_back((*it).first);
	  }
	}
      }
    }
  }
  
  void
  ImageFeatureCollection::getTitlesBaseURIs(std::list<std::string> &list, const std::string &imageFeatureComputerTypeUri) const 
  {
    ContainerType::const_iterator it = m_imageFeaturesComputer.begin();
    const ContainerType::const_iterator itEnd = m_imageFeaturesComputer.end();
    for ( ; it != itEnd ; ++it) {
      if (imageFeatureComputerTypeUri.empty()) {
	list.push_back((*it).first);
      }
      else {
	const std::string uri = (*it).second->baseUri();
	if (imageFeatureComputerTypeUri == uri) {
	  list.push_back((*it).first);
	}
      }
    }
  }

  void 
  ImageFeatureCollection::computersUri(std::set<std::string> &uris) const
  {
    ContainerType::const_iterator it = m_imageFeaturesComputer.begin();
    const ContainerType::const_iterator itEnd = m_imageFeaturesComputer.end();
    for ( ; it != itEnd ; ++it) {
      const std::string uri = (*it).second->imageFeatureComputerUri();
      //std::vector<std::string> computerUris;
      size_t  firstPos = 0;
      size_t pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
      while ( pos <= uri.length() ) {
	uris.insert(uri.substr(firstPos, pos - firstPos));
	firstPos = pos+1;
	pos = uri.find_first_of(ise::ImageFeatureComputer::IMAGE_FEATURE_URI_SEPARATOR, firstPos);
      }
      uris.insert(uri.substr(firstPos, uri.length()));
    }
  }
}

