/*
  Copyright (C) 2005-2010 Vieux Remi, Roigt Julian, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEIMAGEFEATUREBINARYCOMPUTER_HPP
#define ISEIMAGEFEATUREBINARYCOMPUTER_HPP

#include <girl/girlCommon.hpp>

#include "iseImageFeatureColorimetricComputer.hpp"
#include "iseSegmentationContext.hpp"

namespace ise {

  class GIRL_API ImageFeatureBinaryComputer : public ImageFeatureColorimetricComputer
  {
  public:

    static const int GMIN = 0;
    static const int GMAX = 255;
    static const int DIM = 1;

  public:

    explicit ImageFeatureBinaryComputer(ise::SegmentationContext *segC)
      : ImageFeatureColorimetricComputer(segC)
      {
	ImageFeatureComputer::addImageFeatureComputerUri("Binary");
      }
    
    virtual ~ImageFeatureBinaryComputer()
    {
    }

  private:
    ImageFeatureBinaryComputer(const ImageFeatureBinaryComputer&);
    ImageFeatureBinaryComputer &operator=(const ImageFeatureBinaryComputer&);
    
  };
}
#endif /* ! ISEIMAGEFEATUREBINARYCOMPUTER_HPP */
