/*
  3D Histogram cell.
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEHISTOINFO_HPP
#define ISEHISTOINFO_HPP

#include <girlTools/girlToolsImage.hpp>

namespace ise {

  class HistoInfo 
  {

  public:

    inline HistoInfo() 
      : color(0), frequency(0)
    { 
      color = new girl::tools::Image::type[4]; 
      color[0] = 0;
      color[1] = 0;
      color[2] = 0;
      color[3] = 0;
    };

    inline ~HistoInfo() { delete [] color; }

    inline void setColor(int i, girl::tools::Image::type code) { color[i] = code; }
 
    inline void setFrequency(long f) { frequency = f; }
  
    inline girl::tools::Image::type *getColor() const { return color; }

    inline long getFrequency() const { return frequency; }

  private:

    HistoInfo(const HistoInfo &);

    HistoInfo &operator=(const HistoInfo &);
  

  protected:

    girl::tools::Image::type *color;
    long frequency;

  };

}

#endif /* ISEHISTOINFO_HPP */
