/*
  Copyright (C) 2005-2012 Boris Mansencal, Remi Vieux, Jean-Philippe Domenger  boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef ISEGEOMETRICCOMPUTER_HPP
#define ISEGEOMETRICCOMPUTER_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>


namespace ise
{
  class GIRL_API GeometricComputer : public girl::toger::pointIterator
  {
  public:

    GeometricComputer();

    void clear();

    void process(const girl::toger &tog, girl::region r);
    virtual void processPoint(const girl::point& pt);

    void finalize();

    double getArea() const { return m_area; }
    double getXCoordCenter() const { return m_xCoordCenter; }
    double getYCoordCenter() const { return m_yCoordCenter; }
    double getMajorAxisLength() const { return m_majorAxisLength; }
    double getMinorAxisLength() const { return m_minorAxisLength; }
    double getAngleMajorAxisAbscice() const { return m_angleMajorAxisAbscice; }


    GeometricComputer &operator+=(const GeometricComputer &o);
    
    
  protected:
    double m_area;
    double m_x;
    double m_x2;
    double m_y;
    double m_y2;
    double m_xy;
    double m_xCoordCenter;
    double m_yCoordCenter;
    double m_majorAxisLength;
    double m_minorAxisLength;
    double m_angleMajorAxisAbscice;
  };

}

#endif /* ! ISEGEOMETRICCOMPUTER_HPP */
