/*
  Functions on float vector.
  Copyright (C) 2005-2009 Achille Braquelaire, Luc Brun, Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEFLT3TOOLS_HPP
#define ISEFLT3TOOLS_HPP

#include <girl/girlCommon.hpp>
#include <girlTools/girlToolsVector.hpp>


double iseFlt3_dist(const girl::tools::Flt3 &mean1, 
		    const girl::tools::Flt3 &mean2);

double iseFlt3_addition(const girl::tools::Flt3 &bf);

girl::tools::Flt3 iseFlt3_diff(const girl::tools::Flt3 &b1, 
			       const girl::tools::Flt3 &b2);

double iseFlt3_scalarProduct(const girl::tools::Flt3 &b1, 
			     const girl::tools::Flt3 &b2);

double iseDouble_dist(const double *mean1,
		      const double *mean2,
		      size_t size);

void iseDouble_set(double *m1, 
		   const double *m2, 
		   size_t size);

void iseDouble_addition(double *m1, 
			const double *m2, 
			size_t size);

#endif /* ISEFLT3TOOLS_HPP */
