/*
  Functions on float vector.
  Copyright (C) 2005-2009 Achille Braquelaire, Luc Brun, Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseFlt3Tools.hpp"


double iseFlt3_dist(const girl::tools::Flt3 &b1, const girl::tools::Flt3 &b2)
{
  const double x = b1[0] - b2[0];
  const double y = b1[1] - b2[1];
  const double z = b1[2] - b2[2];
  return x * x + y * y + z * z;
}

double 
iseFlt3_addition(const girl::tools::Flt3 &bf)
{
  return bf[0] + bf[1] + bf[2];
}

girl::tools::Flt3
iseFlt3_diff(const girl::tools::Flt3 &b1, const girl::tools::Flt3 &b2)
{
  return girl::tools::Flt3(b1[0] - b2[0], b1[1] - b2[1], b1[2] - b2[2]);
}

double 
iseFlt3_scalarProduct(const girl::tools::Flt3 &b1, const girl::tools::Flt3 &b2)
{
  return iseFlt3_addition(girl::tools::Flt3(b1[0]*b2[0], b1[1]*b2[1], b1[2]*b2[2]));
}


double
iseDouble_dist(const double *mean1, const double *mean2, size_t size)
{
  double ret = 0.0;
  for (size_t i = 0 ; i < size ; ++i) {
    double val = mean1[i] - mean2[i];
    ret += val * val;
  }
  return ret;
}


void 
iseDouble_set(double *m1, const double *m2, size_t size)
{
  for (size_t i = 0 ; i < size ; ++i)
    m1[i] = m2[i];
}
			
void 
iseDouble_addition(double *m1, const double *m2, size_t size)
{
  for (size_t i = 0 ; i < size ; ++i)
    m1[i] += m2[i];
}
			
