/*
  Color spaces conversions functions.
  Copyright (C) 1996, 2004-2009 Luc Brun, Achille Braquelaire, Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * @file iseConversion.hpp
 * @brief 
 */

#ifndef ISECONVERSION_HPP
#define ISECONVERSION_HPP

#include <girl/girlCommon.hpp>

namespace ise {

  typedef enum {RGB=0, Lab=3, Luv=4, HSV=9, HMMD=10, YCbCr=11, YUV=12, GRAY=13} iseColorSpaceType;

  /* From RGB space to X space */  
#define ISE_RGB_to_RGB     0
  //#define ISE_RGB_to_I1I2I3  1
  //#define ISE_RGB_to_H1H2H3  2
#define ISE_RGB_to_Lab     3    
#define ISE_RGB_to_Luv     4
										//#define ISE_RGB_to_YIQ     5
  //#define ISE_RGB_to_V1V2V3  6
															       //#define ISE_RGB_to_K1K2K3  7
															       //#define ISE_RGB_to_T1T2T3  8
  /* sa */
#define ISE_RGB_to_HSV 9
										//#define ISE_RGB_to_HMMD 10
#define ISE_RGB_to_YCbCr 11
#define ISE_RGB_to_YUV 12
#define ISE_RGB_to_GRAY 13


  /* from X space to RGB space */
															       //#define ISE_I1I2I3_to_RGB  1
												   //#define ISE_H1H2H3_to_RGB  2
#define ISE_Lab_to_RGB     3    
#define ISE_Luv_to_RGB     4
										//#define ISE_YIQ_to_RGB     5
												   //#define ISE_V1V2V3_to_RGB  6
															       //#define ISE_K1K2K3_to_RGB  7
															       //#define ISE_T1T2T3_to_RGB  8
  /* sa */
#define ISE_HSV_to_RGB 9
										//#define ISE_HMMD_to_RGB 10
#define ISE_YCbCr_to_RGB 11
#define ISE_YUV_to_RGB 12
#define ISE_RGB_to_GRAY 13
 
  

  namespace conversion {

    /**
     * @brief Function type,
     * that uses 3 components to get 1 component of destination space 
     */
    typedef int (*PFConversion)(int, int, int);

    /**
     * @brief Function type,
     * that uses 3 components to get 3 components of destination space 
     */
    typedef void (*Change3Components)(int r, int g, int b, int &x, int &y, int &z);

    /**
     * @brief Return an array of 3 functions to change one component at a time, 
     * from RGB space to specified color space.
     */
    extern GIRL_API PFConversion *changeSpace(int colorSpace);

    /**
     * @brief Return an array of 3 functions to change one component at a time, 
     * from specified color space back to RGB space.
     */
    extern GIRL_API PFConversion *restoreSpace(int colorSpace);

    /**
     * @brief Return a function to change three components at once, 
     * from RGB space to specified color space.
     */
    extern GIRL_API Change3Components changeSpace3(int colorSpace);

    /**
     * @brief Return a function to change three components at once, 
     * from specified color space back to RGB space.
     */
    extern GIRL_API Change3Components restoreSpace3(int colorSpace);


    extern GIRL_API void changeFromRGB(int colorSpace, int r, int g, int b, int &x, int &y, int &z);

    extern GIRL_API void changeToRGB(int colorSpace, int x, int y, int z, int &r, int &g, int &b);
    

    extern GIRL_API int absoluteMin(int colorSpace, int channel);

    extern GIRL_API int absoluteMax(int colorSpace, int channel);

  }

}

#endif /*ISECONVERSION_HPP*/
