/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISECOMPARISONFUNCTION_HPP
#define ISECOMPARISONFUNCTION_HPP

#include <functional>
#include <girl/girlCommon.hpp>
#include "iseRegionFeature.hpp" //RegionFeature_Data_Type

namespace ise {

  typedef enum {LESS=0, LESS_OR_EQUAL, GREATER, GREATER_OR_EQUAL, EQUAL, NOT_EQUAL} ComparisonOperator; 
  
  typedef bool (*ComparisonFunction) (RegionFeature_Data_Type v1, RegionFeature_Data_Type v2);

  extern GIRL_API ise::ComparisonFunction getComparisonFunction(ise::ComparisonOperator c);

  extern GIRL_API ise::ComparisonOperator getComparisonOperator(ise::ComparisonFunction f);
}

#endif /* ! ISECOMPARISONFUNCTION_HPP */
