/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux boris.mansencal@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "iseComparisonFunction.hpp"


//REM: we can not use std::less, std::greater, ... (?)
// with 
//typedef std::binary_function<RegionFeature_Data_Type, RegionFeature_Data_Type, bool> ComparisonFunction;
//because they have not a common base class with operator()
// ( operator() is not defined in std::binary_function ).

namespace ise {

  namespace {

    bool P_less(RegionFeature_Data_Type v1, RegionFeature_Data_Type v2)
    {
      return v1 < v2;
    }

    bool P_less_equal(RegionFeature_Data_Type v1, RegionFeature_Data_Type v2)
    {
      return v1 <= v2;
    }

    bool P_greater(RegionFeature_Data_Type v1, RegionFeature_Data_Type v2)
    {
      return v1 > v2;
    }

    bool P_greater_equal(RegionFeature_Data_Type v1, RegionFeature_Data_Type v2)
    {
      return v1 >= v2;
    }

    bool P_equal_to(RegionFeature_Data_Type v1, RegionFeature_Data_Type v2)
    {
      return v1 == v2;
    }

    bool P_not_equal_to(RegionFeature_Data_Type v1, RegionFeature_Data_Type v2)
    {
      return v1 != v2;
    }

  } //end anonymous namespace

  ise::ComparisonFunction
  getComparisonFunction(ise::ComparisonOperator c)
  {
    static ComparisonFunction cfs[] = {P_less,
				       P_less_equal,
				       P_greater,
				       P_greater_equal,
				       P_equal_to,
				       P_not_equal_to};

    return cfs[c];
  }

  ise::ComparisonOperator
  getComparisonOperator(ise::ComparisonFunction f)
  {
    if (f == P_less)
      return LESS;
    else if (f == P_less_equal)
      return LESS_OR_EQUAL;
    else if (f == P_greater)
      return GREATER;
    else if (f == P_greater_equal)
      return GREATER_OR_EQUAL;
    else if (f == P_equal_to)
      return EQUAL;
    else if (f == P_not_equal_to)
      return NOT_EQUAL;
    return LESS;
  }

}
