/*
  Color frequency.
  Copyright (C) 2004-2009 Luc Brun, Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef COLORFREQUENCY_HPP
#define COLORFREQUENCY_HPP

#include "iseHashHistogram.hpp"
#include "iseRange.hpp"

namespace ise {

  class Comparator;

  class ColorFrequency
  {

  public :
  
    explicit ColorFrequency(const HashHistogram &histo);
  
    double projection(int, int, const Range<int>*, double*, double*) const;
  
    int getMin(int el) const;

    int getMax(int el) const;
 
 
    int *getMedian(int *, int*) const;
  
  protected:

    int chercher(int val,
		 const std::vector<int> &tab,
		 int min,
		 int max,
		 int el) const;

    bool compare_a_val_I(int i, int val, int el) const;

    
    void creer_entre(int min,
		     int max,
		     const std::vector<int> &tab,
		     std::vector<int> &entre,
		     int el);

    



  protected:

    friend class Comparator;

    struct FreqColor
    {
      FreqColor()
	: m_freq(0)
      {
	m_I[0] = 0;
	m_I[1] = 0;
	m_I[2] = 0;

      }

      FreqColor(size_t f, int i1, int i2, int i3)
	: m_freq(f)
      {
	m_I[0] = i1;
	m_I[1] = i2;
	m_I[2] = i3;
      }

      FreqColor(size_t f, const ise::HashHistogram::Pixel &p)
	: m_freq(f)
      {
	m_I[0] = p[0];
	m_I[1] = p[1];
	m_I[2] = p[2];
      }
      
      int I(int i) const
      {
	return m_I[i];
      }
      
      size_t freq() const
      {
	return m_freq;
      }


      size_t m_freq;
      int m_I[3];
    };

    typedef std::vector<FreqColor> FreqColorCollection;
    FreqColorCollection m_tab_freq;
    std::vector<int> m_tab_I[3];
    std::vector<int> m_entreI[3];
    size_t m_size;
  };

}


#endif /* ! COLORFREQUENCY_HPP */
