/*
  Color frequency.
  Copyright (C) 2004-2009 Luc Brun, Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "iseColorFrequency.hpp"

#include "iseDefinitions.h"

#include <cstdio> //fprintf
#include <algorithm>
#include <iostream> //DEBUG

using namespace ise;


/*
#define TRIE_C1C2 0
#define TRIE_C2C1 1
#define TRIE_C3C1 2
*/

//static int sortFlags[] = {SORT_C0C1=0, SORT_C1C0, SORT_C2C0};
static int nextElt[] = {1, 0, 0};

static int nextElt2[] = {2, 2, 1};

namespace ise {

  class Comparator
  {
  public:

    Comparator(const ise::ColorFrequency::FreqColorCollection &col,
	       int startEl,
	       int currEl)
      : m_freqCols(col)
      , m_startEl(startEl)
      , m_currEl(currEl)
    {

    }

    bool operator()(int i, int j)
    {
      const int val1 = m_freqCols[i].I(m_currEl);
      const int val2 = m_freqCols[j].I(m_currEl);

      if (val1 < val2)
	return true;
      else if (val1 == val2) {
	if (m_startEl == m_currEl)
	  return Comparator(m_freqCols, m_startEl, nextElt[m_currEl])(i, j);
	else 
	  return false;
      }
      return false;
    } 

    const ise::ColorFrequency::FreqColorCollection &m_freqCols;
    int m_startEl;
    int m_currEl;
  };

}

/*
    FreqColorCollection m_tab_freq;
    std::vector<int> m_tab_I[3];
    std::vector<int> m_entreI[3];
    size_t m_size;
 */
ColorFrequency::ColorFrequency(const HashHistogram &histo)
  : m_tab_freq()
  , m_tab_I()
  , m_entreI()
  , m_size(0)
{
  

  m_size = histo.getSize();

  m_tab_I[0].resize(m_size);
  m_tab_I[1].resize(m_size);
  m_tab_I[2].resize(m_size);

  m_tab_freq.resize(m_size);

  for (size_t i=0; i<m_size; ++i)
    m_tab_I[0][i] = m_tab_I[1][i] = m_tab_I[2][i] = i;


  HashHistogram::const_iterator it = histo.begin();
  const HashHistogram::const_iterator itEnd = histo.end();
  FreqColorCollection::iterator itF = m_tab_freq.begin();
  for ( ; it != itEnd; ++it, ++itF) {
    *itF = FreqColor(it->second, it->first);
  }

  std::sort(m_tab_I[0].begin(), m_tab_I[0].end(), Comparator(m_tab_freq, 0, 0));
  std::sort(m_tab_I[1].begin(), m_tab_I[1].end(), Comparator(m_tab_freq, 1, 1));
  std::sort(m_tab_I[2].begin(), m_tab_I[2].end(), Comparator(m_tab_freq, 2, 2));

  const int min_I0 = m_tab_freq[m_tab_I[0][0]].I(0);
  const int min_I1 = m_tab_freq[m_tab_I[1][0]].I(1);
  const int min_I2 = m_tab_freq[m_tab_I[2][0]].I(2);
						 
  const int max_I0 = m_tab_freq[m_tab_I[0][m_size-1]].I(0);
  const int max_I1 = m_tab_freq[m_tab_I[1][m_size-1]].I(1);
  const int max_I2 = m_tab_freq[m_tab_I[2][m_size-1]].I(2);

  m_entreI[0].resize(max_I0-min_I0+1);
  m_entreI[1].resize(max_I1-min_I1+1);
  m_entreI[2].resize(max_I2-min_I2+1);

  creer_entre(min_I0, max_I0, m_tab_I[0], m_entreI[0], 0); 
  creer_entre(min_I1, max_I1, m_tab_I[1], m_entreI[1], 1); 
  creer_entre(min_I2, max_I2, m_tab_I[2], m_entreI[2], 2); 
  

#if 0
  for (int i=0; i<3; ++i) {
    std::cout<<"m_tab_freq[m_tab_I["<<i<<"][i]].I("<<i<<"):"<<std::endl;
    for (size_t j=0; j<m_size; ++j)
      std::cout<<m_tab_freq[m_tab_I[i][j]].I(0)<<" "<<m_tab_freq[m_tab_I[i][j]].I(1)<<" "<<m_tab_freq[m_tab_I[i][j]].I(2)<<"\n";
    std::cout<<std::endl;
      /*
    std::cout<<"m_tab_freq[m_tab_I[1][i]].I(1):"<<std::endl;
    for (size_t j=0; j<m_size; ++j)
      std::cout<<m_tab_freq[m_tab_I[1][j]].I(1)<<" "<<std::endl;
    std::cout<<std::endl
    std::cout<<"m_tab_freq[m_tab_I[2][i]].I(2):"<<std::endl;
    for (size_t j=0; j<m_size; ++j)
      std::cout<<m_tab_freq[m_tab_I[2][j]].I(2)<<" "<<std::endl;
    std::cout<<std::endl
      */
      
    std::cout<<"m_entre[i]:\n";
    for (size_t k=0; k<m_entreI[i].size(); ++k) {
      std::cout<<m_entreI[i][k]<<" \n";
    }
    std::cout<<std::endl;
  }
#endif

}

void
ColorFrequency::creer_entre(int min,
			    int max,
			    const std::vector<int> &tab,
			    std::vector<int> &entre,
			    int el)
{
  size_t i=0;
  int ind = min;

  assert(m_size!=0);
  while (i<m_size) {

    while ((compare_a_val_I(tab[i], ind, el)) && (i<m_size-1)) 
	++i;
    const int val = m_tab_freq[tab[i]].I(el);
    for (int j=ind; j<= val; ++j) 
      entre[j-min] = i; 
    ind = val+1;
    ++i;
  }
  for (int j=ind; j<=max; ++j) 
    entre[j-min] = -1;
}

bool
ColorFrequency::compare_a_val_I(int i, int val, int el) const
{
  const int valp = m_tab_freq[i].I(el);
  if (valp < val)
    return true;
  return false;
}




int
ColorFrequency::getMin(int el) const
{
  return m_tab_freq[m_tab_I[el][0]].I(el);
}

int
ColorFrequency::getMax(int el) const
{
  return m_tab_freq[m_tab_I[el][m_size-1]].I(el);
}

int*
ColorFrequency::getMedian(int *min, int *max) const
{
  static int median[3];
  int ind;
  
  ind = (m_entreI[0][min[0]-getMin(0)]+m_entreI[0][max[0]-getMin(0)])/2;
  median[0] = m_tab_freq[m_tab_I[0][ind]].I(0);
  
  ind = (m_entreI[1][min[1]-getMin(1)]+m_entreI[1][max[1]-getMin(1)])/2;
  median[1] = m_tab_freq[m_tab_I[1][ind]].I(1);
  
  ind = (m_entreI[2][min[2]-getMin(2)]+m_entreI[1][max[2]-getMin(2)])/2;
  median[2] = m_tab_freq[m_tab_I[2][ind]].I(2);
  
  return median;
}
/**************************************************/


double
ColorFrequency::projection(int el,
			   int val,
			   const Range<int> *inter,
			   double *moment1,
			   double *moment2) const
{
  assert(el>=0 && el<3);  

  int elNext1 = nextElt[el]; //(el+1)%3;
  int elNext2 = nextElt2[el]; //(el+2)%3;

  const Range<int> &interNext1 = inter[elNext1];
  const Range<int> &interNext2 = inter[elNext2];

  int minNext1 = interNext1.min();
  int maxNext1 = interNext1.max();
  int minNext2 = interNext2.min();
  int maxNext2 = interNext2.max();

  int max_CEl = getMax(el); //m_tab_freq[m_tab_I[el][m_size-1]].I[el];
  int min = m_entreI[el][val - getMin(el)];

  const std::vector<int> &tab = m_tab_I[el]; //int *tab = m_tab_I[el]; //???
  int half_int = REDUCTION >>1;

  int pcel;//f_coul * pcel;	

  double freq = 0.0;				/* variable de retour */
  		
  int max;
  int min2, max2;
  //double valI1, valI2;
  
  moment1[0] = 0.0;
  moment1[1] = 0.0;
  moment2[0] = 0.0;
  moment2[1] = 0.0;
  
  if ( val != max_CEl) {
    max = m_entreI[el][(val+1) - getMin(el)];
    if (max ==-1)
      max = m_size;
  }
  else
    max = m_size;
  
  if ((max>static_cast<int>(m_size)) || (max<0) || (min<0) || (min>static_cast<int>(m_size)))
    fprintf(stderr, "DANGER : min = %d, max = %d", min, max);

  if ((min != -1) && (min !=max)) {
    /* sinon pas de valeurs superieures ou */
    /* egale a val et strictement */
    /* inferieures a val+1*/
    
      if (max == min+1) { /* une seule valeur verifie la propriete */
	/* ci dessus*/
     
	pcel = tab[min];
	const int INext1 = m_tab_freq[pcel].I(elNext1);
	const int INext2 = m_tab_freq[pcel].I(elNext2);
	if ( (INext1 >= minNext1) && (INext1 < maxNext1)
	     && (INext2 >= minNext2) && (INext2<maxNext2) ) {
	  
	  const double f = static_cast<double>(m_tab_freq[pcel].freq());
	  freq += f;

	  int valNext1 = INext1*REDUCTION;
	  if (INext1 <0)
	    valNext1 -= half_int;
	  else
	    valNext1 += half_int;
	      
	  int valNext2 =  INext2*REDUCTION;
	  if (INext2 <0)
	    valNext2 -= half_int;
	  else
	    valNext2 += half_int;
	      
	  if (el != 1) {
	    moment1[0] = f*valNext1;
	    moment2[0] = f*valNext2;
	    moment1[1] = f*valNext1*valNext1;
	    moment2[1] = f*valNext2*valNext2;
	  }
	  else {
	    moment1[0] = f*valNext2;
	    moment2[0] = f*valNext1;
	    moment1[1] = f*valNext2*valNext2;
	    moment2[1] = f*valNext1*valNext1;
	    
	  }

	}
      }
      else {
	  
	//const int searchEl = nextElt[el];

	min2 = chercher(minNext1,
			tab,
			min,
			max-1,
			elNext1);

	if (min2 != -1) {
	  max2 = chercher(maxNext1,
			  tab,
			  min,
			  max-1,
			  elNext1);
	  
	  max2 = (max2==-1 ? max : max2);

// 	  const int next = nextElt2[el];
// 	  const Range<int> &interNext = inter[next];
// 	  int minNext = interNext.min();
// 	  int maxNext = interNext.max();
	  
	  for (int j=min2; j<max2; ++j) {

	    pcel = tab[j];
	    const int INext1 = m_tab_freq[pcel].I(elNext1);
	    const int INext2 = m_tab_freq[pcel].I(elNext2);
	    if ((INext2>=minNext2) && (INext2 < maxNext2)) {

	      const double f = static_cast<double>(m_tab_freq[pcel].freq());
	      freq += f;

	      int valNext1=(INext1)*REDUCTION;		      
	      if (INext1 <0)
		valNext1 -= half_int;
	      else
		valNext1 += half_int;

	      int valNext2= (INext2)*REDUCTION;
	      if (INext2 <0)
		valNext2 -= half_int;
	      else
		valNext2 += half_int;
		      
	      if (el != 1) {
		moment1[0] += f*valNext1;
		moment2[0] += f*valNext2;
		moment1[1] += f*valNext1*valNext1;
		moment2[1] += f*valNext2*valNext2;
	      }
	      else {
		moment1[0] += f*valNext2;
		moment2[0] += f*valNext1;
		moment1[1] += f*valNext2*valNext2;
		moment2[1] += f*valNext1*valNext1;
	      }
		      
	    }
	  }
	}
      }
    }
  return freq;
}    



/* Recherche dichomatique de val dans le tableau V a l'aide de la */
/* fonction comp */

int
ColorFrequency::chercher(int val,
			 const std::vector<int> &tab,
			 int min,
			 int max,
			 int el) const
{
  int milieu = (min+max)/2;
  
  if (compare_a_val_I(tab[min], val, el) == false)
    return min;
  if (compare_a_val_I(tab[max], val, el) == true)
    return -1;

  if (max-min ==1) {
      if (compare_a_val_I(tab[min], val, el) == true)
	return max;
      else
	return min;
    }

  if (compare_a_val_I(tab[milieu], val, el) == true)
    return chercher(val, tab, milieu, max, el);
  else
    return chercher(val, tab, min, milieu, el);
}

/****************************************************************************/



