/*
  Color binary tree.
  Copyright (C) 2004-2009 Luc Brun, Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef COLOR_BINARY_TREE_HPP
#define COLOR_BINARY_TREE_HPP

#include "iseRange.hpp"

namespace ise {


  class ColorFrequency;

  class ColorBinaryTree
  {
  public:

    /**
     * @brief Destructor.
     */
    ~ColorBinaryTree();

    /**
     * @brief Constructor.
     */
    ColorBinaryTree();

    void clear();

    void set(const ColorFrequency &cf,
	     int chosenCluster,
	     int chosenAxis,
	     int chosenInit,
	     int chosenCut);

    void createTable(ColorFrequency &colFreq,
		     int &nbOfColors,
		     double ecart_max);

    void seekColorInTable(int *color,
			  int &colorIndex);

    void labelLeafes(int *table);


  protected:

    typedef double momentsChildren[2][3];

    typedef int (ColorBinaryTree::*PFdecoupe)(const ColorFrequency &cf, double*, momentsChildren, momentsChildren);
    typedef void (ColorBinaryTree::*PFinit)(const ColorFrequency &cf, double*, double*, double*);
    typedef int (ColorBinaryTree::*PFaxe)(const ColorFrequency &cf);
    typedef double (ColorBinaryTree::*PFcluster)();


    void init();

    int cut(const ColorFrequency &colFreq,
	    double *moment0,
	    momentsChildren moment1,
	    momentsChildren moment2);
    int cutProject(const ColorFrequency &colFreq,
		   double *moment0,
		   momentsChildren moment1,
		   momentsChildren moment2);
    int cutMedian(const ColorFrequency &colFreq,
		  double *moment0,
		  momentsChildren moment1,
		  momentsChildren moment2);
    int cutMedianDangerous(const ColorFrequency &colFreq,
			   double *moment0,
			   momentsChildren moment1,
			   momentsChildren moment2);
  

 

    void initialisation(const ColorFrequency &colFreq,
			double *moment0, 
			double *moment1, 
			double *moment2);
    void initialisationDangerous(const ColorFrequency &colFreq,
				 double *moment0, 
				 double *moment1, 
				 double *moment2);
  
    double cutChoice(const ColorFrequency &colFreq);

    int mseChoice(const ColorFrequency &colFreq);
    int splitVarChoice(const ColorFrequency &colFreq);
    int varChoice(const ColorFrequency &colFreq);
    int lengthChoice(const ColorFrequency &colFreq);
    int varLengthChoice(const ColorFrequency &colFreq);
    int varMedianChoice(const ColorFrequency &colFreq);

    double weightedMSE();
    double nonWeightedMSE();
    double cardinal();

  
    void createTable_aux(const ColorFrequency &colFreq);
    void label(int *table, int &numero);
    ColorBinaryTree *createChild();

  private:
    ColorBinaryTree(ColorBinaryTree &c);
    ColorBinaryTree &operator=(ColorBinaryTree &c);


  protected:
  

    ColorBinaryTree *m_child[2];
    Range<int> m_range[3];
    double m_var[3];
    int m_meanAxis[3];
    double m_ecart; //B: french!?
    int m_cutAxis;
    double m_moment0;
    double m_moment1[3];
    double m_moment2[3];
    int m_number;
    bool m_isLeaf;

    PFaxe m_axisChoiceFn;
    PFcluster m_valueFn;
    PFdecoupe m_partitionFn;
  
  };

}

#endif /* ! COLOR_BINARY_TREE_HPP */

