/*
  Copyright (C) 2005-2011 Remi vieux, Jean-Philippe Domenger, Achille Braquelaire, Jenny Benois-Pineau, Julian Roigt  remi.vieux@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*
  This work was (partly) funded by the X-Media project, sponsored by
  the European Commission as part of the Information Society Technologies
  (IST) program under EC grant number IST-FP6-026978.
*/

#ifndef ISECLUSTERERGENERICKMEANS_HPP
#define ISECLUSTERERGENERICKMEANS_HPP

#include <cstdlib>
#include <sstream>

#include "iseGenericKMeans.hpp"

#include "iseClustererExplicit.hpp"
#include "iseClustererFactoryTemplate.hxx"

namespace ise {

  class GIRL_API ClustererGenericKMeans : public ClustererExplicit
  {
  public:
    ClustererGenericKMeans(unsigned int numberOfClusters = 0)
    : ClustererExplicit(numberOfClusters), 
      m_gkm(numberOfClusters) 
    {
    }

    virtual ~ClustererGenericKMeans()
    {
    }

    const std::string uri() const
    {
      std::stringstream ss(std::ios::in|std::ios::out);
      ss << __FILE__ << "_" << numberClasses();
      std::string s = ss.str();
      return s;
    }

    virtual void compute(const cv::Mat &instances, cv::Mat &output)
    {
      m_gkm.compute(instances, output);
    }

    /*
    virtual void compute(const std::vector<double *> &instances, size_t dim)
    {
      //m_gkm.compute(instances, dim);
    }
    */

    virtual ise::Clusterer::LabelType getCluster(const double *instance, size_t dim) const
    {
      return static_cast<ise::Clusterer::LabelType>(m_gkm.getCluster(instance, dim));
    }
    
    //virtual size_t numberClasses() const { return m_numberClasses; }
    
    virtual void setNumberClasses(size_t numberClasses) { m_gkm.setNumberClasses(numberClasses); m_numberClasses = numberClasses; }

    void setParameters(std::vector<double> *weights = NULL, bool medoid = false)
    {
      //const ise::DistanceComputer &distComputer, 

      //TODO: PASS distance ????

      m_gkm.setParameters(weights, medoid);
    }

    // returns the dimension of the centroids
    inline int getDimension() const
    {
      return m_gkm.getDimension();
    }
    inline bool getMedoid() const
    {
      return m_gkm.getMedoid();
    }

    inline void setMedoid(bool medoid)
    {
      m_gkm.setMedoid(medoid);
    }

    inline unsigned int getNumIter() const
    {
      return m_gkm.getNumIter();
    }

    inline void setNumIter(unsigned int numIter)
    {
      m_gkm.setNumIter(numIter);
    }

    inline const cv::Mat &getCenters() const
    {
      return m_gkm.getCenters();
    }

    //B:design: is it logical to pass a DistanceType here ???
    inline double getCentroidsDistance(int i, int j /*, ise::DistanceType dtype = ise::EUCLIDEAN, void *userData = NULL */)
    {
      //TODO: PASS distance ????
      
      return m_gkm.getCentroidsDistance(i, j);
    }

  private:

    ise::GenericKMeans<double, cvflann::L2<double> > m_gkm;

  };


  struct GenericKMeansFactory {
    typedef ClustererFactoryTemplate<ClustererGenericKMeans > ClustererGenericKMeansFactory;
  };

}

#endif /* ! ISECLUSTERERGENERICKMEANS_HPP */
