/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISECLUSTERERFACTORYTEMPLATE_HXX
#define ISECLUSTERERFACTORYTEMPLATE_HXX

#include <cassert>

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>

#include "iseClusterer.hpp"

namespace ise {
  /**
   * Template for creating factories: speed up the code
   * Use this class if you want to create a factory with
   * no parameters in the constructor
   * It is achieved in one typedef with the right template
   * parameters
   * @see
   * http://www.yolinux.com/TUTORIALS/C++Singleton.html (Last consult Jan. 2011)
   */
  template <typename ConcreteClass>
  class GIRL_API ClustererFactoryTemplate
  {
  public:

    /**
     * Factory is created as a singleton
     * @return The instance of the factory object
     */
    static ClustererFactoryTemplate<ConcreteClass>& instance();

    /**
     * Object create function
     * @return An object of type Interface
     */
    girl::shared_ptr<ise::Clusterer>
    create();

  private:

    ClustererFactoryTemplate<ConcreteClass>() {}
    ClustererFactoryTemplate<ConcreteClass>(const ClustererFactoryTemplate<ConcreteClass>&);
    virtual ~ClustererFactoryTemplate<ConcreteClass>() {}

  private:
    static ClustererFactoryTemplate<ConcreteClass>* m_instance;

  };

  template <typename ConcreteClass>
  ClustererFactoryTemplate<ConcreteClass>&
  ClustererFactoryTemplate<ConcreteClass>::instance()
  {
    if (!m_instance)
      m_instance = new ClustererFactoryTemplate<ConcreteClass>();
    assert(m_instance);
    return *m_instance;
  }

  template <typename ConcreteClass>
  girl::shared_ptr<ise::Clusterer>
  ClustererFactoryTemplate<ConcreteClass>::create()
  {
    girl::shared_ptr<ise::Clusterer> result(new ConcreteClass());
    return result;
  }

  template <typename ConcreteClass>
  ClustererFactoryTemplate<ConcreteClass>*
  ClustererFactoryTemplate<ConcreteClass>::m_instance = NULL;

}
#endif /* ISECLUSTERERFACTORYTEMPLATE_HXX */
