/*
  Copyright (C) 2005-2009 Julian Roigt, Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISECLUSTEREREXPLICIT_HPP
#define ISECLUSTEREREXPLICIT_HPP

#include <girl/girlCommon.hpp>

#include "iseClusterer.hpp"

namespace ise {
  
  class GIRL_API ClustererExplicit : public Clusterer 
  {
  public:
    
    ClustererExplicit(size_t numberClasses = 0)
      : Clusterer(numberClasses)
    {}

    virtual ~ClustererExplicit() {}

    virtual void compute(const cv::Mat &, cv::Mat &) = 0;

    //virtual void compute(const std::vector<double*> &, size_t) = 0;

    virtual LabelType getCluster(const double*, size_t) const = 0;

    std::vector<double*> getElementsOfCluster(LabelType) const { return std::vector<double*>(); } // TODO;

  };
  
}

#endif /* ! ISECLUSTEREREXPLICIT_HPP */
