/*
  Copyright (C) 2005-2009 Julian Roigt, Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ISECLUSTERERCVKMEANS_HPP
#define ISECLUSTERERCVKMEANS_HPP

#include <girl/girlCommon.hpp>

#include "iseClustererExplicit.hpp"
#include "iseClustererFactoryTemplate.hxx"

namespace ise {

  class GIRL_API ClustererCvKMeans : public ClustererExplicit 
  {
  public:

    explicit ClustererCvKMeans(size_t numberClasses = 0);

    virtual ~ClustererCvKMeans() {}

    virtual const std::string uri() const;

    virtual void compute(const cv::Mat &, cv::Mat &);

    void compute(const std::vector<double*>&, size_t);

    virtual ise::Clusterer::LabelType getCluster(const double*, size_t) const;
    
  private:
    
    void buildClusters(const cv::Mat &, cv::Mat *);

  private:

    std::vector<std::vector<double> > m_centers;
  };

  typedef ClustererFactoryTemplate<ClustererCvKMeans> ClustererCvKMeansFactory;

}

#endif /* ! ISECLUSTERERCVKMEANS_HPP */
