/*
  Copyright (C) 2005-2009 Jean-Philippe Domenger, Achille Braquelaire, Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ISECLUSTERER_HPP
#define ISECLUSTERER_HPP

#include <string>
#include <vector>

#include <girl/girlCommon.hpp>

#include <opencv2/core/core.hpp>

namespace ise {

  // TODO: add URI
  class GIRL_API Clusterer 
  {
  public:
    
    typedef int LabelType;
    
  public:
    
    Clusterer(size_t numberClasses = 0) 
      : m_numberClasses(numberClasses)
      {
      }
    
    virtual ~Clusterer() {}
    
    virtual const std::string uri() const = 0;

    /**
     * @brief compute clustering of @a samples and put labels of obtained clusters in @a labels.
     *
     * @param[in] samples  input samples to cluster. Matrix of size NxM: N samples of dimension M, and of type CV_64FC1.
     * @param[out] labels  output labels of cluster. Matrix of size Nx1 and of type CV_32S.
     */
    virtual void compute(const cv::Mat &samples, cv::Mat &labels) = 0;

    // TODO: try to converge with the other compute... but passing
    // and output is good...
    //   virtual void compute(const cv::Mat &data, cv::Mat &output) {}
    
    //virtual void compute(const std::vector<double*> &, size_t) = 0;
    
    virtual size_t numberClasses() const { return m_numberClasses; }
    
    virtual void setNumberClasses(size_t numberClasses) { m_numberClasses = numberClasses; }
    
    /**
     * @brief Return to which cluster a sample @a sample of dimension @a dim belongs to.
     *
     * @param[in] sample input sample. Points to @a dim continuous doubles.
     * @param[in] dim  size of input sample.
     * @return label of cluster to which this sample belongs to.
     */
    virtual LabelType getCluster(const double *sample, size_t dim) const = 0 ;
    
    //virtual bool sameClusters(const double *f1, const double *f2, size_t s) const { return getCluster(f1, s) == getCluster(f2, s); }

  protected:
    
    size_t m_numberClasses;
    
  };
  
}

#endif /* ! ISECLUSTERER_HPP */
