/*
  Quantification base class.
  Copyright (C) 2004-2009 Jean-Philippe Domenger, Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * @file iseAbstractQuantification.hpp
 * @brief Quantification base class.
 */
#ifndef ISEABSTRACTQUANTIFICATION_HPP
#define ISEABSTRACTQUANTIFICATION_HPP



namespace ise {

  class histogram;


  class abstractquantification 
  {
  public:

    virtual ~abstractquantification() {}

    virtual void addColor(const ise::color3 &color, unsigned int frequency) = 0;
    
    virtual void addColorsFromHistogram(const ise::histogram &histo) = 0;

    virtual bool areEquivalent(const ise::color3 &color1, const ise::color3 &color2) = 0; 

    virtual void apply() = 0;

    virtual abstractquantification *clone() = 0;



  };

}


#endif /* ! ISEABSTRACTQUANTIFICATION_HPP */
