/*
  Copyright (C) 2005-2010 Jean-Philippe Domenger, Boris Mansencal,
  Julian Roigt, Remi Vieux remi.vieux@labri.fr
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ISEABSTRACTFACTORYTEMPLATE_HPP
#define ISEABSTRACTFACTORYTEMPLATE_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlSharedPtr.hpp>


namespace ise
{

  class SegmentationContext;
/**
 * Generic class for abstract factories
 * Declare the interface of factory object which
 * create objects of type Interface.
 * Use this class as a facility to create new types
 * which need factories, such as things which must be
 * made plugins.
 * An example of use: declare an interface, and at the
 * end of the interface declaration, create Factory
 * in one typdef.
 * @see iseRegionUnaryFunction.hpp
 */
template <typename Interface>
class GIRL_API AbstractFactoryTemplate
{
public:

  virtual ~AbstractFactoryTemplate() {}

  virtual girl::shared_ptr<Interface>
  create(SegmentationContext *) = 0;

};

}
#endif /* ISEABSTRACTFACTORYTEMPLATE_HPP */
