# - Try to find ISE 
# Once done, it will define
#
# ISE_FOUND - system has ISE
# ISE_INCLUDE_DIRS - ISE include directories
# ISE_DEFINITIONS - Compiler switches required for using ISE
# ISE_LIBRARIES - link these to use ISE

#include(LibFindMacros)


FIND_PACKAGE(GIRLTOOLS REQUIRED)
FIND_PACKAGE(FFTW3 REQUIRED)

SET(ISE_DEFINITIONS ${GIRLTOOLS_DEFINITIONS})

IF (ISE_INCLUDE_DIRS AND ISE_LIBRARIES)
   # in cache already
   SET(ISE_FIND_QUIETLY TRUE)
ENDIF (ISE_INCLUDE_DIRS AND ISE_LIBRARIES)

IF(NOT ISE_LIBRARY OR NOT APPLE)

  #libfind_pkg_check_modules(ISE_PKGCONF ise-0.2)
  IF (NOT WIN32)
    include(FindPkgConfig)
    pkg_check_modules(ISE_PKGCONF ise-0.2)
    SET(ISE_DEFINITIONS ${ISE_DEFINITIONS} ${ISE_PKGCONF_CFLAGS_OTHER})
  ENDIF (NOT WIN32)
  
  
  # Include dir
  find_path(ISE_INCLUDE_DIR
    NAMES ise/iseSegmentationContext.hpp
    PATHS ${ISE_PKGCONF_INCLUDE_DIRS})
  
  # Library
  find_library(ISE_LIBRARY
    NAMES ise-0.2
    PATHS ${ISE_PKGCONF_LIBRARY_DIRS})
  
ENDIF(NOT ISE_LIBRARY OR NOT APPLE)


#set(ISE_PROCESS_INCLUDES ISE_INCLUDE_DIR)
#set(ISE_PROCESS_LIBS ISE_LIBRARY)
#libfind_process(ISE)

INCLUDE(FindPackageHandleStandardArgs)

# handle the QUIETLY and REQUIRED arguments and set ISE_FOUND to TRUE if 
# all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(ISE DEFAULT_MSG ISE_LIBRARY ISE_INCLUDE_DIR)

IF (ISE_FOUND)
  set(ISE_INCLUDE_DIRS ${GIRLTOOLS_INCLUDE_DIRS} ${FFTW3_INCLUDE_DIRS} ${ISE_INCLUDE_DIR})
  set(ISE_LIBRARIES ${GIRLTOOLS_LIBRARIES} ${FFTW3_LIBRARIES} ${ISE_LIBRARY})
#   MESSAGE("find ISE_INCLUDE_DIRS=${ISE_INCLUDE_DIRS}")
#   MESSAGE("find ISE_LIBRARIES=${ISE_LIBRARIES}")
#   MESSAGE("find ISE_INCLUDE_DIR=${ISE_INCLUDE_DIR}")
#   MESSAGE("find ISE_LIBRARY=${ISE_LIBRARY}")
#   MESSAGE("find ISE_LIBRARY=${ISE_LIBRARY}")
# MESSAGE("FindISE.cmake: ISE_DEFINITIONS=${ISE_DEFINITIONS}")

#   MESSAGE("find  ISE_PKGCONF_LDFLAGS=${ISE_PKGCONF_LDFLAGS}")
#   MESSAGE("find  ISE_PKGCONF_LDFLAGS_OTHER=${ISE_PKGCONF_LDFLAGS_OTHER}")
#   MESSAGE("find  ISE_PKGCONF_CFLAGS=${ISE_PKGCONF_CFLAGS}")
#   MESSAGE("find  ISE_PKGCONF_CFLAGS_OTHER=${ISE_PKGCONF_CFLAGS_OTHER}")
ENDIF (ISE_FOUND)


MARK_AS_ADVANCED(ISE_INCLUDE_DIRS ISE_LIBRARIES)

