
#include <cassert>

namespace girl {

  namespace tools {
    
    template<class T>
    PixelStandAlone<T>::PixelStandAlone(const std::vector<T>& values)
      : m_isNull(values.size()<=0),
	m_channels(values.size()),
	m_data(NULL)
    {
      m_data = new T[m_channels];
      for (size_t i=0; i<values.size(); ++i)
	m_data[i] = values[i];
    }

    template<class T>
    PixelStandAlone<T>::PixelStandAlone(const PixelStandAlone<T>& pixel)
      : m_isNull(pixel.isNull()),
	m_channels(pixel.channels()),
	m_data(NULL)
    {
      m_data = new T[m_channels];
      for (int i=0; i<pixel.channels(); ++i)
	m_data[i] = pixel[i];
    }
    
    template<class T>
    PixelStandAlone<T>::PixelStandAlone(const PixelFromImage<T>& pixel)
      : m_isNull(pixel.isNull()),
	m_channels(pixel.channels()),
	m_data(NULL)
    {
      m_data = new T[m_channels];
      for (int i=0; i<pixel.channels(); ++i)
	m_data[i] = pixel[i];
    }
    
    template<class T>
    PixelStandAlone<T>::PixelStandAlone()
      : m_isNull(true),
	m_channels(0),
	m_data(NULL)
    {
    }
    
    template<class T>
    PixelStandAlone<T>::PixelStandAlone(const T *p, unsigned int channels)
      : m_isNull(channels<=0),
	m_channels(channels),
	m_data(NULL)
    {
      m_data = new T[m_channels];
      for (int i=0; i<m_channels; ++i)
	m_data[i] = p[i];
    }
    
    template<class T>
    PixelStandAlone<T>::PixelStandAlone(unsigned int channels)
      : m_isNull(channels==0),
	m_channels(channels),
	m_data(NULL)
    {
      m_data = new T[m_channels];
      for (int i=0; i<m_channels; ++i)
	m_data[i] = 0;
    }
    
    template<class T> T&
    PixelStandAlone<T>::operator[](size_t i)
    {
      assert(i<(size_t)m_channels);
      return m_data[i];
    }
    
    template<class T> T
    PixelStandAlone<T>::operator[](size_t i) const
    {
      assert(i<(size_t)m_channels);
      return m_data[i];
    }
    
    template<class T> bool
    PixelStandAlone<T>::operator==(const PixelStandAlone<T> &p) const
    {
      for (int i=0; i<m_channels; ++i)
	if (m_data[i] != p[i]) return false;
      return true;
    }
  
    template<class T> bool
    PixelStandAlone<T>::operator==(const PixelFromImage<T> &p) const
    {
      for (int i=0; i<m_channels; ++i)
	if (m_data[i] != p[i]) return false;
      return true;
    }
  
    template<class T> bool
    PixelStandAlone<T>::operator!=(const PixelStandAlone<T> &p) const
    {
      return (*this != p);
    }
    
    template<class T> bool
    PixelStandAlone<T>::operator!=(const PixelFromImage<T> &p) const
    {
      return (*this != p);
    }
    
    template<class T> T&
    PixelStandAlone<T>::operator+=(const PixelStandAlone<T> &p)
    {
      for (int i=0; i<m_channels; ++i)
	m_data[i] += p[i];
      return *this;
    }
    
    template<class T> T&
    PixelStandAlone<T>::operator+=(const PixelFromImage<T> &p)
    {
      for (int i=0; i<m_channels; ++i)
	m_data[i] += p[i];
      return *this;
    }
    
    template<class T> PixelStandAlone<T>&
    PixelStandAlone<T>::operator=(const PixelStandAlone<T> &p)
    {
      if ( this != &p) {
	if (p.channels() > m_channels) {
	  delete [] m_data;
	  m_data = new T[p.channels()];
	}

	m_channels = p.m_channels;
	m_isNull = p.m_isNull;

	for (int i = 0 ; i < m_channels ; ++i) {
	  m_data[i] = p.m_data[i];
	}
      }
      return *this;
    }

    template<class T> PixelStandAlone<T>&
    PixelStandAlone<T>::operator=(const PixelFromImage<T> &p)
    {
      if ( this != &p) {
	if (p.channels() > m_channels) {
	  delete [] m_data;
	  m_data = new T[p.channels()];
	}

	m_channels = p.m_channels;
	m_isNull = p.m_isNull;

	for (int i = 0 ; i < m_channels ; ++i) {
	  m_data[i] = p.m_data[i];
	}
      }
      return *this;
    }
  }
  
}
