#ifndef GIRLTOOLS_PIXEL_HPP
#define GIRLTOOLS_PIXEL_HPP

#include <vector>

namespace girl {
  
  namespace tools {
    
    class Image;
    class ImageFeature;

    template <class T>
    class GIRL_API PixelStandAlone;

    template <class T>
    class GIRL_API PixelFromImage
    {
    public:
      
      inline ~PixelFromImage() {delete [] m_data;}
      
      inline explicit PixelFromImage(const std::vector<T> &values);
      inline PixelFromImage(const PixelFromImage<T> &pixel);
      inline PixelFromImage(const PixelStandAlone<T> &pixel);
      inline PixelFromImage(const cv::Mat &src, int x, int y);
      inline PixelFromImage();
      
      inline T &operator[](size_t i);
      inline T operator[](size_t i) const;
      
      inline bool isNull() const {return m_isNull;}
      
      inline int channels() const {return m_channels;}
      
      inline bool operator==(const PixelStandAlone<T> &p) const;
      inline bool operator==(const PixelFromImage<T> &p) const;
      inline bool operator!=(const PixelStandAlone<T> &p) const;
      inline bool operator!=(const PixelFromImage<T> &p) const;
      inline T &operator+=(const PixelStandAlone<T> &p);
      inline T &operator+=(const PixelFromImage<T> &p);
      
      inline PixelFromImage<T> &operator=(const PixelFromImage<T> &p);
      inline PixelFromImage<T> &operator=(const PixelStandAlone<T> &p);

    private:
      
      bool m_isNull;
      int m_channels;
      T *m_data;
      
    };
    
    template <class T>
    class GIRL_API PixelStandAlone
    {
      
    public:
      
      inline ~PixelStandAlone() {delete [] m_data;}
      
      inline explicit PixelStandAlone(const std::vector<T> &values);
      inline explicit PixelStandAlone(const PixelFromImage<T> &pixel);
      inline explicit PixelStandAlone(const PixelStandAlone<T> &pixel);
      inline PixelStandAlone(const T *p, unsigned int size);
      inline PixelStandAlone(unsigned int channels);
      inline PixelStandAlone();
      
      inline T &operator[](size_t i);
      inline T operator[](size_t i) const;
      
      inline bool isNull() const {return m_isNull;}
      
      inline int channels() const {return m_channels;}
      
      inline bool operator==(const PixelStandAlone<T> &p) const;
      inline bool operator==(const PixelFromImage<T> &p) const;
      inline bool operator!=(const PixelStandAlone<T> &p) const;
      inline bool operator!=(const PixelFromImage<T> &p) const;
      inline T &operator+=(const PixelStandAlone<T> &p);
      inline T &operator+=(const PixelFromImage<T> &p);
      
      inline PixelStandAlone<T> &operator=(const PixelFromImage<T> &p);
      inline PixelStandAlone<T> &operator=(const PixelStandAlone<T> &p);
      
    protected:
      
      bool m_isNull;
      int m_channels;
      T *m_data;
      
    };
    
    //-- inline functions -------------------------
    
    template <class T>
    inline PixelStandAlone<T> operator+(const PixelStandAlone<T> &p1,
					const PixelStandAlone<T> &p2) {
      PixelStandAlone<T> result = p1;
      result += p2;
      return result;
    }
    
    template <class T>
    inline PixelStandAlone<T> operator+(const PixelStandAlone<T> &p1,
					const PixelFromImage<T> &p2) {
      PixelStandAlone<T> result = p1;
      result += p2;
      return result;
    }
    
    template <class T>
    inline PixelStandAlone<T> operator+(const PixelFromImage<T> &p1,
					const PixelStandAlone<T> &p2) {
      PixelStandAlone<T> result = p1;
      result += p2;
      return result;
    }
    
    template <class T>
    inline PixelStandAlone<T> operator+(const PixelFromImage<T> &p1,
					const PixelFromImage<T> &p2) {
      PixelStandAlone<T> result = p1;
      result += p2;
      return result;
    }
    
  }
  
}

#include "girlToolsPixelFromImage.hxx"
#include "girlToolsPixelStandAlone.hxx"

#endif /* ! GIRLTOOLS_PIXEL_HPP */
