#include "girlToolsPainter.hpp"

#include "girlToolsRegionInfos.hpp"
#include "TogerPainter.hpp"

namespace { //anonymous namespace

  class Contexter
  {
  public:
    
    explicit Contexter(girl::tools::CvPainter &p)
      : m_p(p)
    {

    }

    inline void set()
    {
      m_p.setShift(1, 1);
    }

    inline void unset()
    {
      m_p.setShift(0, 0);
    }

  protected:
    girl::tools::CvPainter &m_p;
  };
 
  class SegmentDrawer : public girl::tools::BoundaryChangePointIterator
  {
  public:

    explicit SegmentDrawer(girl::tools::CvPainter &p)
      : girl::tools::BoundaryChangePointIterator(),
	m_p(p),
	m_pt()
    {

    }

    inline void begin() {}

    virtual void processFirstPoint(const girl::point &p)
    {
      m_pt = p;
      girl::tools::BoundaryChangePointIterator::processFirstPoint(p);
    }

    virtual void processPoint(const girl::point &p)
    {
      m_p.drawLine(m_pt, p);
      m_pt = p;
    }

    virtual void processLastPoint(const girl::point &p)
    {
      processPoint(p);
    }

    inline void end() {}

  protected:
    girl::tools::CvPainter &m_p;
    girl::point m_pt;
  };

  class SegmentEPDrawer : public girl::tools::BoundaryPointIterator
  {
  public:

    SegmentEPDrawer(girl::tools::CvPainter &p, const girl::euclideanPathSet &eps)
      : girl::tools::BoundaryPointIterator(),
	m_p(p),
	m_pt(),
	m_eps(eps)
    {

    }

    inline void begin() {}

    virtual void processFirstPoint(const girl::point &p)
    {
      set(m_pt, p);
      girl::tools::BoundaryPointIterator::processFirstPoint(p);
    }

    virtual void processPoint(const girl::point &p)
    {
      girl::TPoint<float> pt2;
      set(pt2, p);
      m_p.drawLine(m_pt, pt2);
      m_pt = pt2;
    }

    virtual void processLastPoint(const girl::point &p)
    {
      processPoint(p);
    }

    inline void end() {}


  protected:
    
    inline void set(girl::TPoint<float> &p, const girl::point &pt)
    {
      float xf, yf;
      m_eps.getPoint(pt, xf, yf);
      p = girl::TPoint<float>(xf, yf);
    }

  protected:
    girl::tools::CvPainter &m_p;
    girl::TPoint<float> m_pt;
    const girl::euclideanPathSet &m_eps;

  };

}//end anonymous namespace


  void
  girl::tools::drawToger(girl::tools::CvPainter &p, const girl::toger &tog)
  {
    SegmentDrawer sd(p);
    Contexter ctx(p);
    drawTogerT<SegmentDrawer, Contexter>(sd, ctx, tog);
  }

  void
  girl::tools::drawToger(girl::tools::CvPainter &p, const girl::toger &tog, girl::toger::markFlags mark)
  {
    SegmentDrawer sd(p);
    Contexter ctx(p);
    drawTogerT<SegmentDrawer, Contexter>(sd, ctx, tog, mark);
  }

  void
  girl::tools::drawToger(girl::tools::CvPainter &p, const girl::toger &tog, const girl::euclideanPathSet &eps)
  {
    SegmentEPDrawer sd(p, eps);
    Contexter ctx(p);
    drawTogerT<SegmentEPDrawer, Contexter>(sd, ctx, tog);
  }

  void
  girl::tools::drawToger(girl::tools::CvPainter &p, const girl::toger &tog, const girl::euclideanPathSet &eps,
			    girl::toger::markFlags mark)
  {
    SegmentEPDrawer sd(p, eps);
    Contexter ctx(p);
    drawTogerT<SegmentEPDrawer, Contexter>(sd, ctx, tog, mark);
  }


  void
  girl::tools::drawRegions(girl::tools::CvPainter &p, const girl::toger &tog, 
			      const girl::regionDeque &regions)
  {
    SegmentDrawer sd(p);
    Contexter ctx(p);
    drawRegionsT<SegmentDrawer, Contexter>(sd, ctx, tog, regions);
  }

  void
  girl::tools::drawRegions(girl::tools::CvPainter &p, const girl::toger &tog, 
			      const girl::regionDeque &regions, 
			      girl::toger::markFlags mark)
  {
    SegmentDrawer sd(p);
    Contexter ctx(p);
    drawRegionsT<SegmentDrawer, Contexter>(sd, ctx, tog, regions, mark);

  }

  void
  girl::tools::drawRegions(girl::tools::CvPainter &p, const girl::toger &tog, 
			      const girl::regionDeque &regions, 
			      const girl::euclideanPathSet &eps)
  {
    SegmentEPDrawer sd(p, eps);
    Contexter ctx(p);
    drawRegionsT<SegmentEPDrawer, Contexter>(sd, ctx, tog, regions);
  }

  void
  girl::tools::drawRegions(girl::tools::CvPainter &p, const girl::toger &tog, 
			      const girl::regionDeque &regions, 
			      const girl::euclideanPathSet &eps, 
			      girl::toger::markFlags mark)
  {
    SegmentEPDrawer sd(p, eps);
    Contexter ctx(p);
    drawRegionsT<SegmentEPDrawer, Contexter>(sd, ctx, tog, regions, mark);
  }


  void
  girl::tools::drawDarts(girl::tools::CvPainter &p, const girl::toger &tog, 
			    const girl::dartDeque &darts)
  {
    SegmentDrawer sd(p);
    Contexter ctx(p);
    drawDartsT<SegmentDrawer, Contexter>(sd, ctx, tog, darts);
  }

  void
  girl::tools::drawDarts(girl::tools::CvPainter &p, const girl::toger &tog, 
			    const girl::dartDeque &darts, 
			    girl::toger::markFlags mark)
  {
    SegmentDrawer sd(p);
    Contexter ctx(p);
    drawDartsT<SegmentDrawer, Contexter>(sd, ctx, tog, darts, mark);

  }

  void
  girl::tools::drawDarts(girl::tools::CvPainter &p, const girl::toger &tog, 
			 const girl::dartDeque &darts, 
			 const girl::euclideanPathSet &eps)
  {
    SegmentEPDrawer sd(p, eps);
    Contexter ctx(p);
    drawDartsT<SegmentEPDrawer, Contexter>(sd, ctx, tog, darts);
  }

  void
  girl::tools::drawDarts(girl::tools::CvPainter &p, const girl::toger &tog, 
			    const girl::dartDeque &darts, 
			    const girl::euclideanPathSet &eps, 
			    girl::toger::markFlags mark)
  {
    SegmentEPDrawer sd(p, eps);
    Contexter ctx(p);
    drawDartsT<SegmentEPDrawer, Contexter>(sd, ctx, tog, darts, mark);
  }

