/*
  ImageFeatureAbstract class.
  Copyright (C) 2004-2009 Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GIRLTOOLS_IMAGEFEATUREABSTRACT
#define GIRLTOOLS_IMAGEFEATUREABSTRACT

#include <girl/girlSharedPtr.hpp>

namespace girl {
  
  namespace tools {

    class GIRL_API ImageFeatureAbstract {

    public:
      
      typedef double type;

    public:

      virtual ~ImageFeatureAbstract() {}
      
      virtual int width() const = 0;
      virtual int height() const = 0;
      virtual int bytesPerLine() const = 0;

      virtual int channels() const = 0;

      virtual bool isNull() const = 0;

      virtual type *bits() = 0;
      virtual const type *bits() const = 0;

      inline int formatSize() const { return channels(); }

      virtual PixelFromImage<type> getPixel(int x, int y) = 0;

      virtual const PixelFromImage<type> getPixel(int x, int y) const = 0;

    };
  }
}

#endif /* ! GIRLTOOLS_IMAGEFEATUREABSTRACT */
