/*
  ImageFeature class.
  Copyright (C) 2004-2009 Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef GIRLTOOLS_IMAGEFEATURE_HPP
#define GIRLTOOLS_IMAGEFEATURE_HPP

#include <opencv2/core/core.hpp>

#include <string>

#include <girl/girlSharedPtr.hpp>
#include <girl/girlCommon.hpp>

#include "girlToolsPixel.hpp"
#include "girlToolsImageFeatureAbstract.hpp"

namespace girl {

  namespace tools {
    
    class GIRL_API ImageFeature : public ImageFeatureAbstract
    {
      
      //public:
      
      //typedef double type;
      
    public:
      
      ImageFeature();
      
      explicit ImageFeature(std::string fileName);

      ImageFeature(int width, int height, int channels = 3);
      
      ImageFeature(const ImageFeature &);

      explicit ImageFeature(const cv::Mat &mat);

      void clone(ImageFeature &dest);

      ImageFeature &operator=(const ImageFeature &);

      void create(int width, int height, int channels);

      void release();

      virtual int width() const;
      virtual int height() const;
      virtual int bytesPerLine() const;

      virtual int channels() const;
      
      virtual bool isNull() const;
      
      virtual type *bits();
      virtual const type *bits() const;
      
      type *scanLine(int i);
      const type *scanLine(int i) const;

      bool isContinuous() const { return m_imageFeatureImp.get() && m_imageFeatureImp->isContinuous(); }

      virtual PixelFromImage<type> getPixel(int x, int y);
      
      virtual const PixelFromImage<type> getPixel(int x, int y) const;
      
      type *getPixelPtr(int x, int y);

      const type *getPixelPtr(int x, int y) const;

      void setPixel(int x, int y, const PixelFromImage<type> &p);

      void setPixel(int x, int y, const PixelStandAlone<type> &p);

      const girl::shared_ptr<cv::Mat> cvMat() const { return m_imageFeatureImp; }

      girl::shared_ptr<cv::Mat> cvMat() { return m_imageFeatureImp; }

      // R: Where is the code???
      void setCvMat(girl::shared_ptr<cv::Mat> mat);

    protected:
      
      void copy();

    protected:

      bool m_isNull;
      std::string m_uri;
      girl::shared_ptr<cv::Mat> m_imageFeatureImp;
      
    };

  }

}

#endif /* ! GIRLTOOLS_IMAGEFEATURE_HPP */ 
