# - Try to find GIRLTOOLS 
# Once done, it will define
#
# GIRLTOOLS_FOUND - system has GIRLTOOLS
# GIRLTOOLS_INCLUDE_DIRS - GIRLTOOLS include directories
# GIRLTOOLS_DEFINITIONS - Compiler switches required for using GIRLTOOLS
# GIRLTOOLS_LIBRARIES - link these to use GIRLTOOLS

#include(LibFindMacros)


FIND_PACKAGE(GIRL REQUIRED)
FIND_PACKAGE(ZLIB REQUIRED)
FIND_PACKAGE(OpenCV REQUIRED)


IF (GIRLTOOLS_INCLUDE_DIRS AND GIRLTOOLS_LIBRARIES)
  # in cache already
  SET(GIRLTOOLS_FIND_QUIETLY TRUE)
ENDIF (GIRLTOOLS_INCLUDE_DIRS AND GIRLTOOLS_LIBRARIES)


IF(NOT GIRLTOOLS_LIBRARY AND APPLE)
  INCLUDE(CMakeFindFrameworks)
  CMAKE_FIND_FRAMEWORKS(girlTools-1.0)
  
  IF(girlTools-1.0_FRAMEWORKS)
    FOREACH(dir ${girlTools-1.0_FRAMEWORKS})
      SET(GIRLTOOLS_FMWK_INCLUDES ${GIRLTOOLS_FMWK_INCLUDES} ${dir}/Headers) #add ${dir}/PrivateHeaders ???
    ENDFOREACH(dir)

    find_path(GIRLTOOLS_INCLUDE_DIR
      NAMES girlToolsZBackup.hpp
      PATHS ${GIRLTOOLS_FMWK_INCLUDES}
      )

    SET(GIRLTOOLS_LIBRARY "-framework girlTools-1.0")
  ENDIF(girlTools-1.0_FRAMEWORKS)
ENDIF(NOT GIRLTOOLS_LIBRARY AND APPLE)

SET(GIRLTOOLS_DEFINITIONS ${GIRL_DEFINITIONS})
IF (ZLIB_FOUND)
  SET(GIRLTOOLS_DEFINITIONS "${GIRLTOOLS_DEFINITIONS} -DWITH_ZLIB")
ENDIF(ZLIB_FOUND)

IF(NOT GIRLTOOLS_LIBRARY OR NOT APPLE)

  ##On apple, we want framework to be of higher priority
  # but on linux, if we don't always do this, GIRLTOOLS_DEFINITIONS is not defined the second time we run cmake
  # TODO: investigate...

  #libfind_pkg_check_modules(GIRLTOOLS_PKGCONF girlTools-1.0)
  IF (NOT WIN32)
    include(FindPkgConfig)
    pkg_check_modules(GIRLTOOLS_PKGCONF girlTools-1.0)
    SET(GIRLTOOLS_DEFINITIONS ${GIRLTOOLS_PKGCONF_CFLAGS_OTHER})
    
  ENDIF (NOT WIN32)


  # Include dir
  find_path(GIRLTOOLS_INCLUDE_DIR
    NAMES girlTools/girlToolsZBackup.hpp
    PATHS ${GIRLTOOLS_PKGCONF_INCLUDE_DIRS})

  # Library
  find_library(GIRLTOOLS_LIBRARY
    NAMES girlTools-1.0
    PATHS ${GIRLTOOLS_PKGCONF_LIBRARY_DIRS})

ENDIF()

#set(GIRLTOOLS_PROCESS_INCLUDES GIRLTOOLS_INCLUDE_DIR)
#set(GIRLTOOLS_PROCESS_LIBS GIRLTOOLS_LIBRARY)
#libfind_process(GIRLTOOLS)

INCLUDE(FindPackageHandleStandardArgs)

# handle the QUIETLY and REQUIRED arguments and set GIRLTOOLS_FOUND to TRUE if 
# all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GIRLTOOLS DEFAULT_MSG GIRLTOOLS_LIBRARY GIRLTOOLS_INCLUDE_DIR)

IF (GIRLTOOLS_FOUND)
  #warning: FindOpenCV.cmake : OpenCV_INCLUDE_DIRS deprecated, use OpenCV_INCLUDE_DIR
  set(GIRLTOOLS_INCLUDE_DIRS ${GIRL_INCLUDE_DIRS} ${ZLIB_INCLUDE_DIRS} ${OpenCV_INCLUDE_DIR} ${GIRLTOOLS_INCLUDE_DIR})
  set(GIRLTOOLS_LIBRARIES ${GIRL_LIBRARIES} ${ZLIB_LIBRARIES} ${OpenCV_LIBS} ${GIRLTOOLS_PKGCONF_LDFLAGS_OTHER} ${GIRLTOOLS_LIBRARY})
  #   MESSAGE("FindGIRLTOOLS.cmake GIRLTOOLS_INCLUDE_DIRS=${GIRLTOOLS_INCLUDE_DIRS}")
  #   MESSAGE("find GIRLTOOLS_LIBRARIES=${GIRLTOOLS_LIBRARIES}")
  #   MESSAGE("find GIRLTOOLS_LIBRARY=${GIRLTOOLS_LIBRARY}")
  #   MESSAGE("find GIRLTOOLS_LIBRARIES=${GIRLTOOLS_LIBRARIES}")

  #   MESSAGE("find  GIRLTOOLS_PKGCONF_LDFLAGS=${GIRLTOOLS_PKGCONF_LDFLAGS}")
  #   MESSAGE("find  GIRLTOOLS_PKGCONF_LDFLAGS_OTHER=${GIRLTOOLS_PKGCONF_LDFLAGS_OTHER}")
  #   MESSAGE("FindGIRLTOOLS.cmake  GIRLTOOLS_PKGCONF_CFLAGS=${GIRLTOOLS_PKGCONF_CFLAGS}")
  #   MESSAGE("FindGIRLTOOLS.cmake  GIRLTOOLS_PKGCONF_CFLAGS_OTHER=${GIRLTOOLS_PKGCONF_CFLAGS_OTHER}")
ENDIF (GIRLTOOLS_FOUND)


MARK_AS_ADVANCED(GIRLTOOLS_INCLUDE_DIRS GIRLTOOLS_LIBRARIES)

