/*
  Various utility functions.
  Copyright (C) 2004-2012 Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * @file girlUtils.hpp
 *
 * @brief Various utility functions.
 *
 */
#ifndef GIRL_UTILS_HPP
#define GIRL_UTILS_HPP

#include <cmath>

namespace girl {

static inline
double
nearByInt(double v)
{
  if (v<=0)
    return floor(v+0.5);
  else
    return ceil(v-0.5);
}

}

#endif /* ! GIRL_UTILS_HPP */


