/*
  Unordered set.
  Copyright (C) 2004-2011  Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * @file girlUnorderedSet.hpp
 * @brief Unordered set class.
 */

#ifndef GIRL_UNORDEREDSET_HPP
#define GIRL_UNORDEREDSET_HPP

#include <girl/girlCommon.hpp>




#if defined(_MSC_VER) 
#if (_MSC_VER == 1500 && _MSC_FULL_VER >= 150030729) || (_MSC_VER >= 1600) //VS9 SP1 || VS 10
#define GIRL_UNORDERED_SET_USES_TR1_UNORDERED_SET 1
#endif
#endif

/*
//By adding this, we do not need a girlConfig.h file ...
// Test for GCC > 4.0.0 
#if defined(__GNUC__)
#if __GNUC__ > 4 ||				       \
  (__GNUC__ == 4 && (__GNUC_MINOR__ > 4 ||		 \
		     (__GNUC_MINOR__ == 0 &&			\
		      __GNUC_PATCHLEVEL__ > 0))
#define GIRL_HAVE_TR1_MEMORY 1
#endif
#endif
*/

#if defined(GIRL_UNORDERED_SET_USES_TR1_UNORDERED_SET) || defined(UNORDERED_SET_USES_TR1_UNORDERED_SET) || defined(GIRL_UNORDERED_SET_USES_BOOST_TR1_UNORDERED_SET) || defined(UNORDERED_SET_USES_BOOST_TR1_UNORDERED_SET)


#if defined(_MSC_VER)  || ( defined(__clang__) && __clang_major__ >= 5 )
#include <unordered_set>
#elif defined(GIRL_UNORDERED_SET_USES_TR1_UNORDERED_SET) || defined (UNORDERED_SET_USES_TR1_UNORDERED_SET)
#include <tr1/unordered_set>
#else
#include <boost/tr1/unordered_set>
#endif

namespace girl {

  /**
   * @brief UnorderedSet class.
   */
#if ( defined(__clang__) && __clang_major__ >= 5 )
  template <class Key, 
	    class Hash = std::hash<Key> >
  class unorderedSet : public std::unordered_set<Key, Hash>
  {
  public:
    typedef typename std::unordered_set<Key, Hash>::size_type size_type;
    typedef typename std::unordered_set<Key, Hash>::hasher hasher;


    unorderedSet(size_type n = 10,
		 const hasher &hf = hasher())
      : std::unordered_set<Key, Hash>(n, hf)
    {}
	    
  };
#else
  template <class Key, 
	    class Hash = std::tr1::hash<Key> >
  class unorderedSet : public std::tr1::unordered_set<Key, Hash>
  {
  public:
    typedef typename std::tr1::unordered_set<Key, Hash>::size_type size_type;
    typedef typename std::tr1::unordered_set<Key, Hash>::hasher hasher;


    unorderedSet(size_type n = 10,
		 const hasher &hf = hasher())
      : std::tr1::unordered_set<Key, Hash>(n, hf)
    {}
	    
  };
#endif 


}


#elif defined(GIRL_UNORDERED_SET_USES_EXT_HASH_SET) || defined(UNORDERED_SET_USES_EXT_HASH_SET)


#include <ext/hash_set>

namespace girl {

  template <class Key, 
	    class Hash = __gnu_cxx::hash<Key> >
  class unorderedSet : public __gnu_cxx::hash_set<Key, Hash>
  {
  public:

    typedef typename __gnu_cxx::hash_set<Key, Hash>::size_type size_type;
    typedef typename __gnu_cxx::hash_set<Key, Hash>::hasher hasher;

    unorderedSet(size_type n = 10,
		 const hasher &hf = hasher())
      : __gnu_cxx::hash_set<Key, Hash>(n, hf)
    {}
   

  };
  
}



#elif defined(GIRL_HAVE_STLPORT_HASHMAP) || defined(HAVE_STLPORT_HASHMAP)

#include <hash_set>

namespace girl {

  template <class Key, 
	    class Hash = std::hash<Key> >
  class unorderedSet : public std::hash_set<Key, Hash>
  {

    //TODO !!!
  };
  
}

#elif defined(_MSC_VER)

/*
Visual C++ 1.0           _MSC_VER =  800
Visual C++ 3.0           _MSC_VER =  900
Visual C++ 4.0           _MSC_VER = 1000
Visual C++ 4.2           _MSC_VER = 1020
Visual C++ 5.0           _MSC_VER = 1100
Visual C++ 6.0           _MSC_VER = 1200
Visual C++ 7.0 (VC2002)  _MSC_VER = 1300
Visual C++ 7.1 (VC2003)  _MSC_VER = 1310
Visual C++ 8.0 (VC2005)  _MSC_VER = 1400
Visual C++ 9.0 (VC2008)  _MSC_VER = 1400
     9.0 SP1    -> _MSC_FULL_VER >= 150030729         
Visual C++ 10.0 (VC2010) _MSC_VER = 1600
*/

#include <hash_set>

#if _MSC_VER <=1300  //1200=VC++ 6.0, 1300=VC++ .NET2002 (7.0)
namespace SGI = std;
#else 
namespace SGI = stdext;
#endif

namespace girl {
  
  /*
    It is ugly but we have to modifiy our hasher specifically for Visual C++ !
    
  */

 template <class Key, 
	   class Hash = SGI::hash_compare<Key, std::less<Key> > >
  class unorderedSet : public SGI::hash_set<Key, Hash  >
  {
  public:

    typedef typename SGI::hash_set<Key, Hash >::size_type size_type;

    unorderedSet(size_type /* n */ = 10,
		 const Hash &hf = Hash())
      : SGI::hash_set<Key, Hash >(hf)
    {}
 
  };

/*

 The following solution does not work : it seems we can not have a generic hash_map that 
 works for any kind of Key type and for any kind of Hasher.
 Indeed, for Microsoft Visual C++ std/stdext::hash_map :
  - we need to embed our Hasher in a hash_traits (see below).
  But then we need to have "<" (less) defined on Key type. If it is not defined, we are stuck (for example for girl::point).
  We can not pass an instance of our Hasher to the constructor : because we could build a hash_traits with 
  our instance of Hasher but std/stdext::hash_map constructor needs a const reference on a hash_traits and when 
  we can provide one, it is too late, std/stdext::hash_map constructor has already been called.
*/

	/*
  //code inspired from monotone
  //http://msdn2.microsoft.com/en-us/library/1s1byw77(VS.80).aspx
  //see also http://www.tech-archive.net/Archive/VC/microsoft.public.vc.stl/2004-06/0069.html
  //http://www.tech-archive.net/Archive/VC/microsoft.public.vc.stl/2004-06/0073.html
  

  template<typename T, typename P>
  struct hash_traits
  {
    static const size_t bucket_size = 4;
    static const size_t min_buckets = 8;
	std::less<T> lt;
	P h;
    //hash<T> h;

    size_t operator( )(T const & s) const
    {
      return h(s);
    }
    bool operator( )(T const & a,
                     T const & b) const
    {
      return lt(a, b);
    }
  };

  template <class Key, 
	    class T, 
		class Hash = SGI::hash_compare<Key, std::less<Key> > >
  class unorderedSet : public SGI::hash_map<Key, T, hash_traits<Key, Hash>  >
  {
  public:

    typedef typename SGI::hash_map<Key, T, hash_traits<Key, Hash> >::size_type size_type;

    unorderedSet(size_type n = 10,
	    const Hash &hf = Hash())
		      : SGI::hash_map<Key, T, hash_traits<Key, Hash> >()
//      : SGI::hash_map<Key, T, hash_traits<Key, Hash> >(hf)
    {}
 
   };

*/



}

#else

#error No unordered set implementation is available 

#endif






#endif /* ! GIRL_UNORDEREDSET_HPP */
