/*
  Shared pointer wrapper.
  Copyright (C) 2004-2009  Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
 * @file girlSharedPtr.hpp
 * @brief Shared pointer class.
 */

#ifndef GIRL_SHAREDPTR_HPP
#define GIRL_SHAREDPTR_HPP

#include <girl/girlCommon.hpp>

#if defined(_MSC_VER) 
#if (_MSC_VER == 1500 && _MSC_FULL_VER >= 150030729) || (_MSC_VER >= 1600) //VS9 SP1 || VS10
#define GIRL_HAVE_TR1_MEMORY 1
#endif
#endif

/*
//By adding this, we do not need a girlConfig.h file ...
// __GNUC_MINOR__  __GNUC_PATCHLEVEL__
#if defined(__GNUC__)
#if __GNUC__ > 4 || __GNUC__ == 4 
#define GIRL_HAVE_TR1_MEMORY 1
#endif
#endif
*/

#if defined(GIRL_HAVE_TR1_MEMORY) || defined(HAVE_TR1_MEMORY)

#if defined(_MSC_VER) || ( defined(__clang__) && __clang_major__ >= 5 )
#include <memory>
#else
#include <tr1/memory>
#endif

#if defined(__clang__) && __clang_major__ >= 5 

namespace girl { 
  using std::shared_ptr;
  using std::static_pointer_cast;
  using std::const_pointer_cast;
  using std::dynamic_pointer_cast;
}

#else

namespace girl { 
  using std::tr1::shared_ptr;
  using std::tr1::static_pointer_cast;
  using std::tr1::const_pointer_cast;
  using std::tr1::dynamic_pointer_cast;
}

#endif 


#elif defined(GIRL_HAVE_BOOST_TR1_MEMORY_HPP) || defined(HAVE_BOOST_TR1_MEMORY_HPP)

#include <boost/tr1/memory.hpp>
namespace girl { 
  using std::tr1::shared_ptr;
  using std::tr1::static_pointer_cast;
  using std::tr1::const_pointer_cast;
  using std::tr1::dynamic_pointer_cast;
}

#elif defined(GIRL_HAVE_BOOST_SHARED_PTR_HPP) || defined(HAVE_BOOST_SHARED_PTR_HPP)

#include <boost/shared_ptr.hpp>
namespace girl { 
  using boost::shared_ptr;
  using boost::static_pointer_cast;
  using boost::const_pointer_cast;
  using boost::dynamic_pointer_cast;
}

#else

#error No shared_ptr implementation is available

#endif


#endif /* ! GIRL_SHAREDPTR_HPP */
