/*
  Hash functions for region and dart.
  Copyright (C) 2004-2009  Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
 * @file girlHashFunc.hpp
 * @brief Hash functions for dart and face.
 */

#ifndef GIRL_HASHFUNC_HPP
#define GIRL_HASHFUNC_HPP

#include <girl/girlToger.hpp>



#if defined(_MSC_VER) 
#if (_MSC_VER == 1500 && _MSC_FULL_VER >= 150030729) || (_MSC_VER >= 1600) //VS9 SP1 || VS 10
#define GIRL_HASH_MAP_USES_TR1_UNORDERED_MAP 1
#endif
#endif


#if defined(GIRL_HASH_MAP_USES_TR1_UNORDERED_MAP) || defined(HASH_MAP_USES_TR1_UNORDERED_MAP) || defined(GIRL_HASH_MAP_USES_BOOST_TR1_UNORDERED_MAP) || defined(HASH_MAP_USES_BOOST_TR1_UNORDERED_MAP)

#if defined(_MSC_VER) || ( defined(__clang__) && __clang_major__ >= 5 )
#include <unordered_map>
#elif defined(GIRL_HASH_MAP_USES_TR1_UNORDERED_MAP) || defined (HASH_MAP_USES_TR1_UNORDERED_MAP)
#include <tr1/unordered_map>
#else
#include <boost/tr1/unordered_map>
#endif


namespace std {

#if ( defined(__clang__) && __clang_major__ >= 5 ) 
  //nothing
#elif !defined(_MSC_VER) || (_MSC_VER < 1600)
 //From Visual C++ 2010, i.e., _MSC_VER >= 1600, hash is not in the tr1 namespace
  namespace tr1 {
#endif

    template<>
    struct hash<girl::dart>
//      : public std::unary_function<girl::dart, std::size_t>
    {
      std::size_t
      operator()(girl::dart d) const
      { 
	return static_cast<std::size_t>(d); 
      }
    };

    template<>
    struct hash<girl::face>
      : public std::unary_function<girl::face, std::size_t>
    {
      std::size_t
      operator()(girl::face f) const
      { 
	return static_cast<std::size_t>(f); 
      }
    };



    /*
    template<>
    inline size_t
    hash<girl::dart>::operator()(girl::dart d) const
    { 
      return static_cast<size_t>(d); 
    }

    template<>
    inline size_t
    hash<girl::face>::operator()(girl::face f) const
    { 
      return static_cast<size_t>(f); 
    }
    */

#if ( defined(__clang__) && __clang_major__ >= 5 )
    //nothing
#elif !defined(_MSC_VER) || (_MSC_VER < 1600)
  }
#endif

}


#elif defined(GIRL_HASH_MAP_USES_GOOGLE_SPARSE_HASH_MAP) || defined(HASH_MAP_USES_GOOGLE_SPARSE_HASH_MAP)
//#elif defined(GIRL_HAVE_GOOGLE_SPARSE_HASH_MAP) || defined(HAVE_GOOGLE_SPARSE_HASH_MAP)

#include <google/sparse_hash_map>

#error No hash specializations for dart & face available 


#elif defined(GIRL_HASH_MAP_USES_GOOGLE_DENSE_HASH_MAP) || defined(HASH_MAP_USES_GOOGLE_DENSE_HASH_MAP)
//#elif defined(GIRL_HAVE_GOOGLE_DENSE_HASH_MAP) || defined(HAVE_GOOGLE_DENSE_HASH_MAP)

#include <google/dense_hash_map>

#error No hash specializations for dart & face available 


#elif defined(GIRL_HASH_MAP_USES_EXT_HASH_MAP) || defined(HASH_MAP_USES_EXT_HASH_MAP)
//#elif defined(GIRL_HAVE_EXT_HASH_MAP) || defined(HAVE_EXT_HASH_MAP)

#include <ext/hash_map>

namespace __gnu_cxx {

    template<>
    struct hash<girl::dart>
      : public std::unary_function<girl::dart, std::size_t>
    {
      std::size_t
      operator()(girl::dart d) const
      { 
	return static_cast<std::size_t>(d); 
      }
    };

    template<>
    struct hash<girl::face>
      : public std::unary_function<girl::face, std::size_t>
    {
      std::size_t
      operator()(girl::face f) const
      { 
	return static_cast<std::size_t>(f); 
      }
    };



    /*
    template<>
    inline size_t
    hash<girl::dart>::operator()(girl::dart d) const
    { 
      return static_cast<size_t>(d); 
    }

    template<>
    inline size_t
    hash<girl::face>::operator()(girl::face f) const
    { 
      return static_cast<size_t>(f); 
    }
    */


}
//#error No hash specializations for dart & face available 

#elif defined(GIRL_HAVE_STLPORT_HASHMAP) || defined(HAVE_STLPORT_HASHMAP)

#include <hash_map>

#if _MSC_VER <=1300  //1200=VC++ 6.0, 1300=VC++ .NET2002 (7.0)
namespace SGI = std;
#else 
namespace SGI = stdext;
#endif

#error No hash specializations for dart & face available 

#else

#error No hash specializations for dart & face available 

#endif


#endif /* ! GIRL_HASHFUNC_HPP */
