/*
  Flags
  Copyright (C) 2008-2009 Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
 * @file girlFlags.hpp
 * @brief Some functions/classes to manipulate flags.
 */

#ifndef GIRLFLAGS_HPP
#define GIRLFLAGS_HPP

namespace girl {

  template <typename Enum>
  class Flags
  {
  public:
    typedef Enum enum_type;

    inline Flags()
      : m_i(0)
    {}

    inline Flags(const Flags &f) 
      : m_i(f.m_i)
    {}

    inline Flags(Enum f)
      : m_i(f)
    {}

    inline operator int() const { return m_i; }

    inline Flags &operator=(const Flags &f) 
    {
      m_i = f.m_i;
      return *this;
    }
  
    inline Flags &operator&=(int mask) 
    {
      m_i &= mask;
      return *this;
    }
  
    inline Flags &operator&=(unsigned int mask) 
    {
      m_i &= mask;
      return *this;
    }
  
    inline Flags &operator|=(Flags f) 
    {
      m_i |= f.m_i;
      return *this;
    }
  
    inline Flags &operator^=(Flags f) 
    {
      m_i ^= f.m_i;
      return *this;
    }
  

    inline Flags operator|(Flags f) 
    {
      Flags t;
      t.m_i = m_i | f.m_i;
      return t;
    }
  
    inline Flags operator|(Enum e) 
    {
      Flags t;
      t.m_i = m_i | Flags(e);
      return t;
    }
  
    inline Flags operator^(Flags f) 
    {
      Flags t;
      t.m_i = m_i ^ f.m_i;
      return t;
    }
  
    inline Flags operator^(Enum e) 
    {
      Flags t;
      t.m_i = m_i ^ e;
      return t;
    }
  
    inline Flags operator&(Enum e) 
    {
      Flags t;
      t.m_i = m_i & e;
      return t;
    }
  

    inline Flags operator~() 
    {
      Flags t;
      t.m_i = ~m_i;
      return t;
    }
  
    inline bool operator!() const 
    { 
      return !m_i; 
    }

  protected:
    int m_i;
  };

}

#define GIRL_DECLARE_FLAGS(DFlags, Enum)\
  typedef girl::Flags<Enum> DFlags;

#define GIRL_DECLARE_OPERATORS_FOR_FLAGS(DFlags) \
inline girl::Flags<DFlags::enum_type> operator|(DFlags::enum_type f1, DFlags::enum_type f2) \
{ return girl::Flags<DFlags::enum_type>(f1) | f2; } \
inline girl::Flags<DFlags::enum_type> operator|(DFlags::enum_type f1, girl::Flags<DFlags::enum_type> f2) \
{ return f2 | f1; }


#endif /* ! GIRLFLAGS_HPP */
