/*
  Freeman code based clockwise oriented closed contours
  Copyright (C) 2004-2009 Achille Braquelaire, Jean-Philippe Domenger, Gabriel de Dietrich, Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "girlContour.hpp"

#include <cassert>

using namespace girl;

bool 
contour::isPositivelyOriented() const
{
  if (length() == 0)
    return true;

  freemanCodePath::const_dir_iterator it = freemanCodePath::begin();
  assert(it != freemanCodePath::end());
  girl::direction d0, dprev;
  d0 = dprev = *it;
  const freemanCodePath::const_dir_iterator itEnd = freemanCodePath::end();
  int c = 0;
  for ( ; it != itEnd ; ++it) {
    girl::direction d = *it;
    
    if (d == dprev.next())
      ++c;
    else if (d == dprev.previous())
      --c;
    dprev = d;
  }
  if (d0 == dprev.next())
    ++c;
  else if (d0 == dprev.previous())
    --c;
  
  return c > 0;
}

