/*
  Various macros for GIRL
  Copyright (C) 2005-2009 Boris Mansencal  boris.mansencal@labri.fr
 
  This file is part of GIRL.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
 * @file girlCommon.hpp
 * @brief Some functions common macros.
 */

#ifndef GIRL_COMMON_H
#define GIRL_COMMON_H

#if defined(HAVE_CONFIG_H) || defined(GIRL_HAVE_CONFIG_H)
#  include <girl/girlConfig.h>
#endif

#ifdef __cplusplus
#  define GIRL_BEGIN_C_DECLS extern "C" {
#  define GIRL_END_C_DECLS   }
#else /* !__cplusplus */
#  define GIRL_BEGIN_C_DECLS
#  define GIRL_END_C_DECLS
#endif /* __cplusplus */


// Shared library support
#ifdef WIN32
  #define GIRL_IMPORT __declspec(dllimport)
  #define GIRL_EXPORT __declspec(dllexport)
  #define GIRL_DLLLOCAL
  #define GIRL_DLLPUBLIC
#else
  #define GIRL_IMPORT
  #ifdef GCC_HASCLASSVISIBILITY
    #define GIRL_EXPORT __attribute__ ((visibility("default")))
    #define GIRL_DLLLOCAL __attribute__ ((visibility("hidden")))
    #define GIRL_DLLPUBLIC __attribute__ ((visibility("default")))
  #else
    #define GIRL_EXPORT
    #define GIRL_DLLLOCAL
    #define GIRL_DLLPUBLIC
  #endif
#endif

// Define GIRL_API for DLL builds
#ifdef GIRL_DLL
  #ifdef GIRL_DLL_EXPORTS
    #define GIRL_API GIRL_EXPORT
  #else
    #define GIRL_API GIRL_IMPORT
  #endif // GIRL_DLL_EXPORTS
#else
  #define GIRL_API
#endif // GIRL_DLL

// Throwable classes must always be visible on GCC in all binaries
#ifdef WIN32
  #define GIRL_EXCEPTIONAPI(api) api
#elif defined(GCC_HASCLASSVISIBILITY)
  #define GIRL_EXCEPTIONAPI(api) GIRL_EXPORT
#else
  #define GIRL_EXCEPTIONAPI(api)
#endif


#if __GNUC__ >= 3
# define GIRL_inline		inline __attribute__ ((always_inline))
# define GIRL_pure		__attribute__ ((pure))
# define GIRL_const	        __attribute__ ((const))
# define GIRL_noreturn	        __attribute__ ((noreturn))
# define GIRL_malloc	        __attribute__ ((malloc))
# define GIRL_must_check	__attribute__ ((warn_unused_result))
# define GIRL_deprecated	__attribute__ ((deprecated))
# define GIRL_used		__attribute__ ((used))
# define GIRL_unused	        __attribute__ ((unused))
# define GIRL_packed	        __attribute__ ((packed))
# define GIRL_likely(x)	        __builtin_expect (!!(x), 1)
# define GIRL_unlikely(x)	__builtin_expect (!!(x), 0)
#else
# define GIRL_inline		/* no inline */
# define GIRL_pure		/* no pure */
# define GIRL_const	        /* no const */
# define GIRL_noreturn	        /* no noreturn */
# define GIRL_malloc	        /* no malloc */
# define GIRL_must_check	/* no warn_unused_result */
# define GIRL_deprecated	/* no deprecated */
# define GIRL_used		/* no used */
# define GIRL_unused	        /* no unused */
# define GIRL_packed	        /* no packed */
# define GIRL_likely(x)	        (x)
# define GIRL_unlikely(x)	(x)
#endif


#endif /* !GIRL_COMMON_H */
