/*
  Bresenham line algorithm (with 4-connexe directions).
  Copyright (C) 2004-2009 Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
 * @file girlBresenhamDir.hpp
 * @brief Some functions to get lines (made of 4-connexe directions) between two points.
 */

#ifndef BRESENHAMDIRS_HPP
#define BRESENHAMDIRS_HPP

#include <deque>
#include <girl/girlPoint.hpp>

namespace girl {

  /**
   * @brief Compute line with Bresenham algorithm between points 
   * @a startPt and @a endPt.
   *
   * Fill @a dirs with directions describing line from 
   * @a startPt to @a endPt.
   */
  extern GIRL_API void BresenhamDirs(const girl::point &startPt, 
				     const girl::point &endPt,
				     std::deque<girl::direction> &dirs);
    
  /**
   * @brief Utility function to check that directions between 
   * two points are valid.
   *
   * Check only taht there is not two opposite directions in @a dirs,
   * and that we indeed arrive to endPt starting from @a startPt 
   * following @a dirs.
   *
   * @warning 
   */
  extern GIRL_API bool checkDirs(const girl::point &startPt, 
				 const girl::point &endPt,
				 const std::deque<girl::direction> &dirs);
      
}

#endif /* ! BRESENHAMDIRS_HPP */
