/*
  Bresenham line algorithm (with 4-connexe directions).
  Copyright (C) 2004-2009 Boris Mansencal  boris.mansencal@labri.fr
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "girlBresenhamDir.hpp"

#ifndef NDEBUG
#include <iostream>
#endif



/**
 * This preprocessor drective allow to change between two implementations
 * of Bresneham line drawing algorithm.
 * According to tests, second implementation seems faster with g++ -O3
 */

#if 0

/**
 * Code inspired from http://www.edepot.com/algorithm.html
 */
static
void
Bresenham_dirs(int x1, int y1, int x2, int y2,
		 std::deque<girl::direction> &dirs) {
  int x, y;
  int dx, dy;
  int incx, incy;
  int balance;
  girl::direction dirx = girl::INVALID;
  girl::direction diry = girl::INVALID;


  if (x2 >= x1) {
    dx = x2 - x1;
    incx = 1;
    dirx = girl::RIGHT;
  }
  else {
    dx = x1 - x2;
    incx = -1;
    dirx = girl::LEFT;
  }

  if (y2 >= y1) {
    dy = y2 - y1;
    incy = 1;
    diry = girl::DOWN;
  }
  else {
    dy = y1 - y2;
    incy = -1;
    diry = girl::UP;
  }

  x = x1;
  y = y1;

  if (dx >= dy) {
    dy <<= 1;
    balance = dy - dx;
    dx <<= 1;

    while (x != x2) {
      //pts.push_back(girl::point(x, y));//tracerPixel(x, y);
      dirs.push_back(dirx);
      balance += dy;
      x += incx;
      if (balance >= dy) {
	dirs.push_back(diry);
	y += incy;
	balance -= dx;
      }
    } 
    //pts.push_back(girl::point(x, y));//tracerPixel(x, y);
    if (y!=y2)
      dirs.push_back(diry);
  }
  else {
    dx <<= 1;
    balance = dx - dy;
    dy <<= 1;

    while (y != y2) {
      //pts.push_back(girl::point(x, y));//tracerPixel(x, y);
      dirs.push_back(diry);
      balance += dx;
      y += incy;
      if (balance >= dx) {
	dirs.push_back(dirx);
	x += incx;
	balance -= dy;
      }
    } 
    //pts.push_back(girl::point(x, y));//tracerPixel(x, y);
    if (x!=x2)
      dirs.push_back(dirx);
  }
}

#else

static
void
Bresenham_dirs(int x1, int y1, int x2, int y2,
		 std::deque<girl::direction> &dirs)
{
  //girl::direction dir = girl::INVALID;

  int dx = x2 - x1;
  if (dx != 0) {
    if (dx > 0) {
      int dy = y2 - y1;
      if (dy != 0) {
	if (dy > 0) {
	  //vecteur oblique dans le 1er quadran

	  if (dx >= dy) {
	    //vecteur diagonal ou oblique proche de l'horizontale,
	    // dans le 1er octant
	    
	    int e = dx; //e est psoitif
	    dx = e * 2;
	    dy *= 2;
	    for ( ; ; ) { //deplacements horizontaux
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      x1 += 1;
	      dirs.push_back(girl::RIGHT);

	      if (x1 == x2) {
		if (y1 < y2) //B: for last point
		  dirs.push_back(girl::DOWN);
		break;
	      }
	      e = e - dy;
	      if (e < 0) {
		y1 += 1;   //deplacement diagonal 
		e += dx;
		dirs.push_back(girl::DOWN);
	      }
	    }
	  }
	  else {
	    //vecteur oblique proche de la verticale,
	    // dans le 2nd octant
	    
	    int e = dy;
	    dy = e*2;
	    dx *= 2;
	    for ( ; ; ) {
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      y1 += 1;
	      dirs.push_back(girl::DOWN);
	      if (y1 == y2) {
		if (x1 < x2) //B: for last point
		  dirs.push_back(girl::RIGHT);
		break;
	      }
	      e -= dx;
	      if (e < 0) {
		x1 += 1;
		e += dy;
		dirs.push_back(girl::RIGHT);
	      }
	    }
	  }
	}
	else { //dy < 0 (et dx > 0)
	  // vecteur oblique dans le 4e cadran

	  if (dx >= -dy) {
	    // vecteur diagonal ou oblique proche de l'horizontale,
	    // dans le 8eme octant
	    int e = dx; //e est positif
	    dx = e * 2;
	    dy *= 2; 
	    for ( ; ; ) {
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      x1 += 1;
	      dirs.push_back(girl::RIGHT);
	      if (x1 == x2) {
		if (y1 > y2)  //B: for last point
		  dirs.push_back(girl::UP);
		break;
	      }
	      e += dy;
	      if (e < 0) {
		y1 -= 1; //deplacement diagonal
		e += dx;
		dirs.push_back(girl::UP);
	      }
	    }
	  }
	  else { 
	    //vecteur oblique proche de la verticale, dans le 7eme octant
	    int e = dy; //e est negatif
	    dy = e*2;
	    dx *= 2;
	    for ( ; ; ) {
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      y1 -= 1;
	      dirs.push_back(girl::UP);
	      if (y1 == y2) {
		if (x1 < x2) //B: for last point
		  dirs.push_back(girl::RIGHT);
		break;
	      }
	      e += dx;
	      if (e > 0) {
		x1 += 1; //deplacement diagonal
		e += dy;
		dirs.push_back(girl::RIGHT);
	      }
	    }
	  }
	}
      }
      else { //dy = 0 (et dx > 0)
	  
	//vecteur horizontal vers la droite
	while (x1!=x2) {
	  x1 += 1;
	  dirs.push_back(girl::RIGHT);
	}
	  
	// 	do {
	// 	  //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	// 	  x1 += 1;
	// 	  dirs.push_back(girl::RIGHT);
	// 	}
	// 	while (x1 != x2);
		
      }
    }
    else { //dx < 0
      int dy = y2 - y1;
      if (dy != 0) {
	if (dy > 0) {
	  //vecteur oblique dans le 2nd quadran

	  if (-dx >= dy) {
	    //vecteur diagonal ou oblique proche de l'horizontale,
	    //dans le 4eme octant
	    
	    int e = dx; //e est negatif
	    dx *= 2;
	    dy *= 2;
	    for ( ; ; ) { //deplacements horizontaux
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      x1 -= 1;
	      dirs.push_back(girl::LEFT);
	      if (x1 == x2) {
		if (y1 < y2) //B: for last point
		  dirs.push_back(girl::DOWN);
		break;
	      }
	      e += dy;
	      if (e >= 0) {
		y1 += 1; //deplacement diagonal
		e += dx;
		dirs.push_back(girl::DOWN);
	      }
	    }
	  }
	  else {
	    //vecteur oblique proche de la verticale dans le 3e octant
	    int e = dy; //e est positif
	    dy *= 2;
	    dx *= 2;
	    for ( ; ; ) { //deplacement verticaux
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      y1 += 1;
	      dirs.push_back(girl::DOWN);
	      if (y1 == y2) {
		if (x1 > x2)  //B: for last point
		  dirs.push_back(girl::LEFT);
		break;
	      }
	      e += dx;
	      if (e <= 0) {
		x1 -= 1; //deplacement diagonal
		e += dy;
		dirs.push_back(girl::LEFT);
	      }
	    }
	  }
	}
	else { //dy < 0 (et dx < 0)
	  //vecteur oblique dans le 3e quadran

	  if (dx <= dy) {
	    //vecteur diagonal ou oblique proche de l'horizontale,
	    // dans le 5e octant
	    int e = dx; //e est negatif
	    dx *= 2;
	    dy *= 2;
	    for ( ; ; ) { //deplacement horizontaux
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      x1 -= 1;
	      dirs.push_back(girl::LEFT);
	      if (x1 == x2) {
		if (y1 > y2)  //B: for last point
		  dirs.push_back(girl::UP);
		break;
	      }
	      e -= dy;
	      if (e >= 0) {
		y1 -= 1;
		e += dx;
		dirs.push_back(girl::UP);
	      }
	    }
	  }
	  else {
	    //vecteur oblique proche de la verticale,
	    //dans le 6e octant
	    int e = dy; //e est negatif
	    dy *= 2;
	    dx *= 2;
	    for ( ; ; ) { //deplacements verticaux
	      //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	      y1 -= 1;
	      dirs.push_back(girl::UP);
	      if (y1 == y2) {
		if (x1 > x2)  //B: for last point
		  dirs.push_back(girl::LEFT);
		break;
	      }
	      e -= dx;
	      if (e >= 0) {
		x1 -= 1; //deplacement diagonal
		e += dy;
		dirs.push_back(girl::LEFT);
	      }
	    }
	  }
	}
      }
      else { //dy = 0 (et dx< 0)

	//vecteur horizontal vers la gauche
	while (x1 != x2) {
	  x1 -= 1;
	  dirs.push_back(girl::LEFT);
	}

	// 	do {
	// 	  //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	// 	  x1 -= 1;
	// 	  dirs.push_back(girl::LEFT);
	// 	}
	// 	while (x1 == x2);

      }
    }
  }
  else { //dx = 0
    int dy = y2 - y1;
    if (dy != 0) {
      if (dy > 0) {
	//vecteur vertical croissant
	while (y1 != y2) {
	  y1 += 1;
	  dirs.push_back(girl::DOWN);
	}

	// 	do {
	// 	  //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	// 	  y1 += 1;
	// 	  dirs.push_back(girl::DOWN);
	// 	}
	// 	while (y1 != y2);
	  
      }
      else { //dy<0 (et dx = 0)
	  
	//vecteur vertical decroissant
	while (y1 != y2) {
	  y1 -= 1;
	  dirs.push_back(girl::UP);
	}

	// 	do {
	// 	  //pts.push_back(girl::point(x1, y1));//tracerPixel(x1, y1);
	// 	  y1 -= 1;
	// 	  dirs.push_back(girl::UP);
	// 	}
	// 	while (y1 != y2);
      }
    }
  }       
  
  //pts.push_back(girl::point(x2, y2));//tracerPixel(x2, y2);
}

#endif

void
girl::BresenhamDirs(const girl::point &startPt, 
			   const girl::point &endPt,
			   std::deque<girl::direction> &dirs)
{
  Bresenham_dirs(startPt.x(), startPt.y(), endPt.x(), endPt.y(), dirs);
}






#ifndef NDEBUG
std::ostream &
operator<<(std::ostream &o, girl::direction d)
{
  switch (d) {
  case 0:
    o<<"RIGHT ";
    break;
  case 1:
    o<<"UP ";
    break;
  case 2:
    o<<"LEFT ";
    break;
  case 3:
    o<<"DOWN ";
    break;
  default:
  case -2:
    o<<"!!!INVALID!!! ";
    break;
  }
  return o;
}
#endif

bool
girl::checkDirs(const girl::point &startPt, 
		       const girl::point &endPt,
		       const std::deque<girl::direction> &dirs)
{
  girl::point pt = startPt;
  girl::direction prevDir = girl::INVALID;
  std::deque<girl::direction>::const_iterator it = dirs.begin();
  const std::deque<girl::direction>::const_iterator itEnd = dirs.end();
  for (size_t i=0 ; it != itEnd; ++it, ++i) {
    if (it->opposite() == prevDir) {
#ifndef NDEBUG
      std::cerr<<"Bresenham checkDirs: line from ("<<startPt.x()<<", "<<startPt.y()<<") to ("<<endPt.x()<<", "<<endPt.y()<<") ; error: two oposite dirs, at point "<<i<<" ("<<pt.x()<<", "<<pt.y()<<") : prevDir="<<prevDir<<" & nextDir="<<*it<<" !!!"<<std::endl;
#endif
      return false;
    }
    prevDir = *it;

    pt.move(*it);
    
  }
  if (pt != endPt) {
#ifndef NDEBUG
    std::cerr<<"Bresenham checkDirs: line from ("<<startPt.x()<<", "<<startPt.y()<<") to ("<<endPt.x()<<", "<<endPt.y()<<") ; dirs:"<<std::endl;
    for (it = dirs.begin(); it != itEnd; ++it) {
      std::cerr<<*it<<" ";
    }
    std::cerr<<std::endl;
    std::cerr<<"Reached endPt=("<<pt.x()<<", "<<pt.y()<<") instead of ("<<endPt.x()<<", "<<endPt.y()<<")"<<std::endl;
#endif
    return false;
  }
  return true;
}
