/*
  Set of euclidean points
  Copyright (C) 2005-2009 Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef EUCLIDEANPOINTSET_HPP
#define EUCLIDEANPOINTSET_HPP

#include <girl/girlCommon.hpp>

#include <girl/girlPoint.hpp>
#include <girl/girlPointHashMap.hpp>

#include "euclideanPath.hpp"

namespace girl {

  class GIRL_API euclideanPointSet
  {
  public:
  
    typedef euclideanPath::EP_SHIFT_TYPE euclideanShiftValues[2];
  
  
    /**
     * @brief Constructor.
     *
     * @param width   image width.
     * @param height  image height.
     */
    euclideanPointSet(girl::POINT_TYPE width, girl::POINT_TYPE height);

    /**
     * @brief Get width.
     */
    girl::POINT_TYPE width() const
    {
      return m_width;
    }

    /**
     * @brief Get height.
     */
    girl::POINT_TYPE height() const
    {
      return m_height;
    }

    /**
     * @brief Clear set.
     */
    void clear();
  
    /**
     * @brief Add shifts @a vals to point @a pt.
     */
    void addShifts(const girl::point &, const euclideanShiftValues &vals); 
  
    /**
     * @brief Finalize points insertions.
     *
     * Will compute mean of added shifts to get final values.
     */
    void finalize();
  
    /**
     * @return number of points in set.
     *
     * O(1).
     */
    size_t size() const
    {
      return m_hashMap.size();
    }

    /**
     * @brief Get shifts in @a val for a given point @a pt.
     *
     * @warning @a finalize must have been called before calling this method.
     * @warning point @a pt must have been previously added, else result is undefined.
     */
    void getShifts(const girl::point &pt, euclideanShiftValues &vals) const; 


  protected:

    //TODO use type traits to get promote type...
#ifdef EP_QUANTIF
    typedef int EP_SHIFT_SUM;
#else
    typedef euclideanPath::EP_SHIFT_TYPE EP_SHIFT_SUM;
#endif
    

    struct sumShifts
    {
      sumShifts(euclideanPath::EP_SHIFT_TYPE x=0, euclideanPath::EP_SHIFT_TYPE y=0)
	: x_val(x), y_val(y), card(1)
      {}

      EP_SHIFT_SUM x_val;
      EP_SHIFT_SUM y_val;
      unsigned char card;
    };



    typedef girl::pointHashMap<sumShifts> HashMapType;

    HashMapType m_hashMap;

    girl::POINT_TYPE m_width;
    girl::POINT_TYPE m_height;

  };

}

#endif /* EUCLIDEANPOINTSET_HPP */

