/*
  Set of euclidean points
  Copyright (C) 2005-2009 Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <cassert>
#include <limits>
#include "euclideanPointSet.hpp"

using namespace girl;

euclideanPointSet::euclideanPointSet(girl::POINT_TYPE pWidth, 
				     girl::POINT_TYPE pHeight)
  :  m_hashMap(pHeight), m_width(pWidth), m_height(pHeight)
{

}

void
euclideanPointSet::clear()
{
  m_hashMap.clear();
}

void
euclideanPointSet::addShifts(const girl::point &pt, const euclideanShiftValues &vals)
{ 
  const HashMapType::iterator it = m_hashMap.find(pt);
  if (it != m_hashMap.end()) {
    /*   */
    //a node with this point exists, it is updated
    sumShifts &euclidN = it->second;
    euclidN.x_val += vals[0];
    euclidN.y_val += vals[1];
    euclidN.card++;
  }
  else {
    //node with this point not found, it is cretated and inserted.
    //m_hashMap[p] = sumShifts(static_cast<xy_value>(vals[0]), static_cast<xy_value>(vals[1]));

    m_hashMap.insert(std::pair<girl::point, euclideanPointSet::sumShifts>(pt, 
									  sumShifts(vals[0], vals[1])));
    
  }
}

void 
euclideanPointSet::finalize()
{
  HashMapType::iterator it = m_hashMap.begin();
  const HashMapType::iterator itEnd = m_hashMap.end();
  for ( ; it != itEnd; ++it ) {
    sumShifts &euclidN = it->second;
    assert(euclidN.card != 0);
    euclidN.x_val /= euclidN.card; //if EP_QUANTIF defined, integer division ! Is it what we really want ???
    euclidN.y_val /= euclidN.card;
#ifndef NDEBUG
    euclidN.card = 0;
#endif
  }
}

void
euclideanPointSet::getShifts(const girl::point &pt, euclideanShiftValues &vals) const
{
  const HashMapType::const_iterator it = m_hashMap.find(pt);
  if (it != m_hashMap.end()) {
    const sumShifts &euclidN = it->second;
    assert(euclidN.card == 0); //check that finalize() has been called

    assert(euclidN.x_val < std::numeric_limits<euclideanPath::EP_SHIFT_TYPE>::max());
    assert(euclidN.y_val < std::numeric_limits<euclideanPath::EP_SHIFT_TYPE>::max());

    vals[0] = euclidN.x_val;
    vals[1] = euclidN.y_val;
  }
  else {
    assert(false);
    vals[0] = vals[1] = 0;
  } 
}


