/*
  Set of euclidean points
  Copyright (C) 2005-2009 Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef EUCLIDEANPATHSET_HPP
#define EUCLIDEANPATHSET_HPP

#include <girl/girlCommon.hpp>
#include <girl/girlToger.hpp>

#include "euclideanPointSet.hpp"

namespace girl {

  class GIRL_API euclideanPathSet
  {
  public:
  
    /**
     * @brief Constructor.
     *
     * @param width   image width.
     * @param height  image height.
     */
    euclideanPathSet(girl::POINT_TYPE width, girl::POINT_TYPE height);

    /**
     * @brief Get width.
     */
    girl::POINT_TYPE width() const
    {
      return m_pointSet.width();
    }

    /**
     * @brief Get height.
     */
    girl::POINT_TYPE height() const
    {
      return m_pointSet.height();
    }

    /**
     * @brief Initialize with points of all regions of @a tog.
     *
     * Will clear previous points.
     */
    void initFromAllRegions(const girl::toger &tog);

    /**
     * @brief Initialize with points of regions @a regions of @a tog.
     *
     * Will clear previous points.
     */
    void initFromRegions(const girl::toger &tog, const girl::regionDeque &regions);

    /**
     * @brief Initialize with points of face @a f of @a tog.
     *
     * Will clear previous points.
     */
    void initFromFace(const girl::toger &tog, girl::face f);

    /**
     * @brief Initialize with points of darts @a darts of @a tog.
     *
     * Will clear previous points.
     */
    //void initFromDarts(const girl::toger &tog, const std::deque<girl::dart> &darts);
  

    /**
     * @return number of points in set.
     *
     * O(1).
     */
    size_t size() const
    {
      return m_pointSet.size();
    }

    /**
     * @brief Get floating point coordinates for discrete point @a pt in @a x and @a y.
     *
     * @warning @a pt must be a point previously added to set, 
     *  else result is undefined.
     */
    void getPoint(const girl::point &pt, girl::REAL_TYPE &x, girl::REAL_TYPE &y) const;
  
  protected:

    /**
     * @brief Clear set.
     */
    void clear();
  
    void addFace(const girl::toger &tog, girl::face f);
  
    //void addDart(const girl::toger &tog, girl::dart d);
  
    void updatePointSetForEP(const euclideanPath &ep);



  protected:
  
    euclideanPointSet m_pointSet;

  };

}

#endif /* ! EUCLIDEANPATHSET_HPP */
