/*
  Set of euclidean points
  Copyright (C) 2005-2009 Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "euclideanPathSet.hpp"

using namespace girl;

euclideanPathSet::euclideanPathSet(girl::POINT_TYPE pWidth, girl::POINT_TYPE pHeight)
  : m_pointSet(pWidth, pHeight)
{
  
}

//DEBUG
#include <iostream>


void
euclideanPathSet::clear()
{
  //std::cerr<<"clear"<<std::endl;

  m_pointSet.clear();
}

void
euclideanPathSet::updatePointSetForEP(const euclideanPath &ep)
{
  euclideanPointSet::euclideanShiftValues vals;

  euclideanPath::const_iterator it = ep.begin();
  const euclideanPath::const_iterator itEnd = ep.end();
  for ( ; it != itEnd; ++it) {

    //std::cerr<<"add ("<<it.getPoint().x()<<"; "<<it.getPoint().y()<<")"<<std::endl;
  
    //std::cerr<<"add ("<<it.getPoint().x()<<"; "<<it.getPoint().y()<<")"<<std::endl;
  
    it.getShifts(vals[0], vals[1]);
    
    m_pointSet.addShifts(it.getPoint(), vals);
  }
}

void
euclideanPathSet::addFace(const girl::toger &tog, girl::face f)
{
  girl::contour c;
  tog.regionOuterBoundary(f, c);

  euclideanPath euclid(c);
  //??? euclid.reinitialize();

  updatePointSetForEP(euclid);
}

/*
  void
  euclideanPathSet::addDart(const girl::toger &tog, girl::dart d)
  {
  girl::path p;
  tog.segment(d, p);

  euclideanPath euclid(p, true); //warning: add last point !
  //??? euclid.reinitialize();

  updatePointSetForEP(euclid);

  //replace use of contour by use of girl::fremancodePath in euclidean/discretePath
  //Problem: current implementation of discreteLine consider a closed contour !!!
  }
*/



void
euclideanPathSet::initFromAllRegions(const girl::toger &tog)
{
  //std::cerr<<"euclideanPathSet::initFromAllRegions()"<<std::endl;


  girl::regionDeque regions;
  tog.allRegions(regions);

  initFromRegions(tog, regions);
}

void
euclideanPathSet::initFromRegions(const girl::toger &tog, const girl::regionDeque &regions)
{
  m_pointSet.clear();

  girl::contour c;
  euclideanPath ep;

  girl::regionDeque::const_iterator it = regions.begin();
  const girl::regionDeque::const_iterator itEnd = regions.end();
  for ( ; it != itEnd; ++it) {
    //addFace(tog, *it);

    //std::cerr<<"r="<<*it<<std::endl;

    tog.regionOuterBoundary(*it, c);
    
    ep.set(c);
    
    updatePointSetForEP(ep);
  }

  m_pointSet.finalize();
}

void
euclideanPathSet::initFromFace(const girl::toger &tog, girl::face f)
{
  m_pointSet.clear();

  addFace(tog, f);

  m_pointSet.finalize();
}

/*
  void
  euclideanPathSet::initFromDarts(const girl::toger &tog, const std::deque<girl::dart> &darts)
  {
  m_pointSet.clear();
  
  std::deque<girl::dart>::const_iterator it = regions.begin();
  const std::deque<girl::dart>::const_iterator itEnd = regions.end();
  for ( ; it != itEnd; ++it) {
  addDart(tog, *it);
  }

  m_pointSet.finalize();

  
  //REM: we should probably first check if a dart follows another one.
  // Currently, we will probably add the same point several times...
  }
*/

void
euclideanPathSet::getPoint(const girl::point &pt, girl::REAL_TYPE &x, girl::REAL_TYPE &y) const
{
  euclideanPointSet::euclideanShiftValues vals;
  m_pointSet.getShifts(pt, vals); 

  x = static_cast<girl::REAL_TYPE>(pt.x()) + euclideanPath::realValue(vals[0]);
  y = static_cast<girl::REAL_TYPE>(pt.y()) - euclideanPath::realValue(vals[1]);//warning: change of Coordinate System

  assert(x < static_cast<girl::REAL_TYPE>(pt.x())+0.5f);
  assert(x > static_cast<girl::REAL_TYPE>(pt.x())-0.5f);
  assert(y < static_cast<girl::REAL_TYPE>(pt.y())+0.5f);
  assert(y > static_cast<girl::REAL_TYPE>(pt.y())-0.5f);
}
 
