/*
  Discrete line
  Copyright (C) 2005 Anne Vialard  anne.vialard@labri.fr
  Copyright (C) 2009 Boris Mansencal  boris.mansencal@labri.fr

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef DISCRETE_LINE_HPP
#define DISCRETE_LINE_HPP

#include <girl/girlDirection.hpp>
#include <girl/girlPoint.hpp>

namespace girl {

  class GIRL_API discreteLine
  {
  public:

    /**
     * @brief Constructor.
     */
    discreteLine();

    int a() const
    {
      return m_a;
    }

    int b() const
    {
      return m_b;
    }
  
    int mu() const
    {
      return m_mu;
    }

    /**
     *
     *
     * @param initialStep 
     */
    void init(bool initialStep);

    /**
     * @brief Check of a point (x, y) can be added to segment (without modifying the line)
     */
    bool checkAdd(girl::POINT_TYPE x, girl::POINT_TYPE y) const;

    
    /**
     * @brief Add a point to positive abscissa extremity of segment
     * for 4-connexe line of 1st quadrant.
     *
     * adapted Debled method
     *
     * @return true if point could be added to line, else false.
     */
    bool addPositivePoint(girl::POINT_TYPE x, girl::POINT_TYPE y);
  
    /**
     * @brief Add a point to negative abscissa extremity of segment
     * for 4-connexe line of 1st quadrant.
     *
     * adapted Debled method
     *
     * @return true if point could be added to line, else false.
     */
    bool addNegativePoint(girl::POINT_TYPE x, girl::POINT_TYPE y);
  
    /**
     * @brief Delete point at negative abscissa extremity of segment 
     * of 4-connexe line of first quadrant.
     *
     *
     * @param dx number of horizontal steps of initial segment
     * @param dy number of vertical steps of initial segment
     */
    void deleteNegativePoint(girl::POINT_TYPE x, girl::POINT_TYPE y,
			     girl::POINT_TYPE dx, girl::POINT_TYPE dy);


    void translateFrame(girl::POINT_TYPE dx, girl::POINT_TYPE dy);

  protected:
    int m_a;
    int m_b;
    int m_mu;

    girl::point m_U; //upper leaning point of minimum abscissa
    girl::point m_L; //lower leaning point of minimum abscissa
    girl::point m_Us; //upper leaning point of maximum abscissa
    girl::point m_Ls; //lower leaning point of maximum abscissa
  };

}

#endif /* ! DISCRETE_LINE_HPP */
