# - Try to find GIRL 
# Once done, it will define
#
# GIRL_FOUND - system has GIRL
# GIRL_INCLUDE_DIRS - GIRL include directories
# GIRL_DEFINITIONS - Compiler switches required for using GIRL
# GIRL_LIBRARIES - link these to use GIRL

#include(LibFindMacros)


IF (GIRL_INCLUDE_DIRS AND GIRL_LIBRARIES)
  # in cache already
  SET(GIRL_FIND_QUIETLY TRUE)
ENDIF (GIRL_INCLUDE_DIRS AND GIRL_LIBRARIES)


IF(APPLE)
  INCLUDE(CMakeFindFrameworks)
  CMAKE_FIND_FRAMEWORKS(girl-2.0)
  
  IF(girl-2.0_FRAMEWORKS)
    FOREACH(dir ${girl-2.0_FRAMEWORKS})
      SET(GIRL_FMWK_INCLUDES ${GIRL_FMWK_INCLUDES} ${dir}/Headers) #add ${dir}/PrivateHeaders ???
    ENDFOREACH(dir)

    find_path(GIRL_INCLUDE_DIR
      NAMES girl/girlHashMap.hpp
      PATHS ${GIRL_FMWK_INCLUDES}
      )

    SET(GIRL_LIBRARY "-framework girl-2.0")
  ENDIF(girl-2.0_FRAMEWORKS)

ENDIF(APPLE)


IF(NOT GIRL_LIBRARY OR NOT APPLE)

  ##On apple, we want framework to be of higher priority
  # but on linux, if we don't always do this, GIRL_DEFINITIONS is not defined the second time we run cmake
  # TODO: investigate...



  #libfind_pkg_check_modules(GIRL_PKGCONF girl-2.0)
  IF (NOT WIN32)
    include(FindPkgConfig)
    pkg_check_modules(GIRL_PKGCONF girl-2.0)
    SET(GIRL_DEFINITIONS ${GIRL_PKGCONF_CFLAGS_OTHER})
  ENDIF (NOT WIN32)


  # Include dir
  find_path(GIRL_INCLUDE_DIR
    NAMES girl/girlHashMap.hpp
    PATHS ${GIRL_PKGCONF_INCLUDE_DIRS}
    /usr/include/girl-2.0
    /usr/local/include/girl-2.0
    )

  # Library
  find_library(GIRL_LIBRARY
    NAMES girl-2.0
    PATHS ${GIRL_PKGCONF_LIBRARY_DIRS}
    /usr/lib
    /usr/local/lib
    )

ENDIF()


#set(GIRL_PROCESS_INCLUDES GIRL_INCLUDE_DIR)
#set(GIRL_PROCESS_LIBS GIRL_LIBRARY)
#libfind_process(GIRL)


if(EXISTS ${GIRL_INCLUDE_DIR} AND NOT EXISTS ${GIRL_DEFINITIONS})
  find_path(HAVE_GIRL_CONFIG NAMES girl/girlConfig.h
    PATHS ${GIRL_INCLUDE_DIR}
    )
  if(EXISTS ${HAVE_GIRL_CONFIG})
    SET(GIRL_DEFINITIONS "-DGIRL_HAVE_CONFIG_H")
  endif(EXISTS ${HAVE_GIRL_CONFIG})
endif(EXISTS ${GIRL_INCLUDE_DIR} AND NOT EXISTS ${GIRL_DEFINITIONS})



INCLUDE(FindPackageHandleStandardArgs)

# handle the QUIETLY and REQUIRED arguments and set GIRL_FOUND to TRUE if 
# all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(GIRL DEFAULT_MSG GIRL_LIBRARY GIRL_INCLUDE_DIR)

IF (GIRL_FOUND)
  set(GIRL_INCLUDE_DIRS ${GIRL_INCLUDE_DIR})
  set(GIRL_LIBRARIES ${GIRL_LIBRARY})
  #   MESSAGE("find GIRL_INCLUDE_DIRS=${GIRL_INCLUDE_DIRS}")
  #   MESSAGE("find GIRL_LIBRARIES=${GIRL_LIBRARIES}")
  #   MESSAGE("find GIRL_INCLUDE_DIR=${GIRL_INCLUDE_DIR}")
  #   MESSAGE("find GIRL_LIBRARY=${GIRL_LIBRARY}")
  #   MESSAGE("find GIRL_LIBRARY=${GIRL_LIBRARY}")

  #   MESSAGE("find  GIRL_PKGCONF_LDFLAGS=${GIRL_PKGCONF_LDFLAGS}")
  #   MESSAGE("find  GIRL_PKGCONF_LDFLAGS_OTHER=${GIRL_PKGCONF_LDFLAGS_OTHER}")
  #   MESSAGE("find  GIRL_PKGCONF_CFLAGS=${GIRL_PKGCONF_CFLAGS}")
  #   MESSAGE("find  GIRL_PKGCONF_CFLAGS_OTHER=${GIRL_PKGCONF_CFLAGS_OTHER}")
  #   MESSAGE("FindGIRL.cmake: GIRL_DEFINITIONS=${GIRL_DEFINITIONS}")
ENDIF (GIRL_FOUND)


MARK_AS_ADVANCED(GIRL_INCLUDE_DIRS GIRL_LIBRARIES)

