#!/bin/sh

#Colors
RED='\e[0;31m'
GREEN='\e[0;32m'
ORANGE='\e[0;33m'
GREY='\e[0;37m'
NORMAL='\e[0;m'

#Global vars
RESULTDIR="."
COMMAND="./stats.sh "

echo_err() {
  echo -e $RED $1 $NORMAL
}

echo_succ() {
  echo -e $GREEN $1 $NORMAL
}

echo_warn() {
  echo -e $ORANGE $1 $NORMAL
}

echo_emph() {
  echo -e $GREY $1 $NORMAL
}

usage(){
  echo "Usage: ./launcher.sh -videoDir <videos directory> -binary <binary file to bench> <arguments>"
  echo "If no argument given, the script returns immediatly."
  echo "Values for <arguments> :"
  echo "  -split                print values needed to make a curve."
  echo "  -plot                 display the curves created."
  echo "  -cpu			display cpu in the curves' title"
  echo "  -gpu			display gpu in the curves' title"
  echo "  -stats                make stats (average and standard deviation)."
  echo "  -boxplot              display the average and some things interesting."
  echo "  -dir <directory>      store results inside the <directory>, by default it's the current directory."
  echo "  -start <directory>	begin with this directory"
  echo "  -end <directory>	end with this directory"
  echo "  -help, -h             show this help."
}


#----------------------------------------------------------------
# Main
#----------------------------------------------------------------

#parse parameters
while [[ $# > 0 ]]
do
  key="$1"

  case $key in
    "-help"|"-h")
      usage;
      exit;
    ;;
    "-split")
      COMMAND=$COMMAND"-split "
    ;;
    "-plot")
      COMMAND=$COMMAND"-plot "
    ;;
    "-boxplot")
      COMMAND=$COMMAND"-boxplot "
    ;;
    "-stats")
      COMMAND=$COMMAND"-stats "
    ;;
    "-cpu")
      COMMAND=$COMMAND"-cpu "
    ;;
    "-gpu")
      COMMAND=$COMMAND"-gpu "
    ;;
    "-start")
      START="$2"
      shift
    ;;
    "-end")
      END="$2"
      shift
    ;;
    "-binary")
      BINARY="$2"
      shift
    ;;
    "-videoDir")
      VIDEODIR="$2"
      shift
    ;;
    "-hd")
      HD="-R 0 0"
    ;;
    "-dir")
      RESULTDIR="$2"
      RESULTDIR=$(echo $RESULTDIR | sed -e "s/\/\//\//g")
      if [ -f $RESULTDIR ]
      then
        echo_err "$RESULTDIR is a file... We can't store data inside !"
        exit;
      fi
      if [ ! -e $RESULTDIR ]
      then
        mkdir $RESULTDIR;
      fi
      shift
    ;;
    *)
      echo_err "$key : Parameter unrecognized" 
      usage;
      exit;
    ;;
  esac
shift 
done

if [ -z $VIDEODIR ] || [ ! -e $VIDEODIR ]
then
  echo_err "Directory doesn't exist or is empty"
  usage;
  exit;
fi

if [ -z $BINARY ]
then
  echo_err "Binary file is empty"
  usage;
  exit;
fi

# Keep only directories choosen
LSDIR=$(ls $VIDEODIR)
if [ ! -z START ]; then
  LSDIR=$(echo $LSDIR | sed -e "s/^.*$START/$START/")
fi
if [ ! -z END ]; then
  LSDIR=$(echo $LSDIR | sed -e "s/$END.*$/$END/")
fi


for i in $LSDIR ; do


  if [ -f $VIDEODIR/$i ]
  then
    echo_warn "$i is not a directory !"
    echo_warn "Continuing..."
    continue;
  fi

  TMPDIR=$RESULTDIR"/$i/"
  TMPJSON="$VIDEODIR/$i/$i.json"
  TMPMP4="$VIDEODIR/$i/$i.mp4"

  if [ ! -e $TMPJSON ] || [ ! -e $TMPMP4 ]
  then
    echo_warn "$TMPMP4 or $TMPJSON doesn't exist !"
    echo_warn "Continuing..."
    continue;
  fi

  if [ ! -e $TMPDIR ]
  then
    mkdir $TMPDIR;
  fi

  echo_emph "Bench of $(echo $VIDEODIR/$i... | sed -e "s/\/\//\//g")"
    $BINARY $VIDEODIR/$i/$i.json $VIDEODIR/$i/$i.mp4 $HD > $TMPDIR/$i-1.txt 2> /dev/null
  echo_succ "Done !"
    cat  $TMPDIR/$i-1.txt | sed -e "/^Parse/ d" > $TMPDIR/$i.txt
  echo_emph "Make results of $(echo $VIDEODIR/$i... | sed -e "s/\/\//\//g")"
    $COMMAND "-file" $TMPDIR/$i.txt "-dir" $TMPDIR
  echo_succ "Done !"
    rm $TMPDIR/$i-1.txt $TMPDIR/$i.txt
done


cd $RESULTDIR
sum=0
for dir in * ; do
	sum=0
	if [ -d $dir ]; then
		cd $dir;
		for num in $(cut -f 5 -d ' ' Stats_eyes_open.*); do
			sum=$(($sum + $num))
		done
		cd ..
		echo $sum >> sums.txt
	fi
done
echo "Done"
cat */Stats_eyes_open.* | sed -n '1~3p' | cut -f 5 -d' ' > saliencies.txt
cat */Stats_eyes_open.* | sed -n '2~3p' | cut -f 5 -d' ' > heats.txt
cat */Stats_eyes_open.* | sed -n '3~3p' | cut -f 5 -d' ' > interpolations.txt

echo_succ "TERMINATED !"

